/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.configs.ScreeningConfig;
import com.bcxin.backend.dtos.bg.BgScreeningParams;
import com.bcxin.backend.dtos.bg.BgScreeningResultDto;
import com.bcxin.backend.entity.BgScreeningUser;
import com.bcxin.backend.entity.BgScreeningUserExecLog;
import com.bcxin.backend.entity.BgScreeningUserResult;
import com.bcxin.backend.entity.Employees;
import com.bcxin.backend.service.BgScreeningService;
import com.bcxin.backend.service.BgScreeningUserExecLogService;
import com.bcxin.backend.service.BgScreeningUserResultService;
import com.bcxin.backend.service.BgScreeningUserService;
import com.bcxin.backend.service.EmployeesService;
import com.bcxin.backend.strategy.bg.BgScreeningStrategy;
import com.bcxin.backend.strategy.bg.BgScreeningStrategyFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BgScreeningServiceImpl
implements BgScreeningService {
    private static final Logger log = LoggerFactory.getLogger(BgScreeningServiceImpl.class);
    @Autowired
    private BgScreeningUserService bgScreeningUserService;
    @Autowired
    private BgScreeningUserResultService bgScreeningUserResultService;
    @Autowired
    private BgScreeningUserExecLogService bgScreeningUserExecLogService;
    @Autowired
    private EmployeesService employeesService;
    @Autowired
    private ScreeningConfig screeningConfig;

    @Transactional
    public void runNewRecruit() {
        List newRecruitUserList = this.bgScreeningUserService.findNewRecruitUser(this.screeningConfig.getScheduled().getInductionCount().intValue());
        if (CollectionUtil.isEmpty((Collection)newRecruitUserList)) {
            log.info("\u6267\u884c\u65b0\u5165\u804c\u80cc\u7b5b\uff0c\u4eba\u6570\u4e3a0\uff0c\u4e0d\u6267\u884c");
        } else {
            List bgUserIdnumList = newRecruitUserList.stream().map(BgScreeningUser::getIdnum).collect(Collectors.toList());
            log.info("\u6267\u884c\u65b0\u5165\u804c\u80cc\u7b5b\uff0c\u4eba\u6570\uff1a{}\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}", (Object)bgUserIdnumList.size(), (Object)JSONObject.toJSONString(bgUserIdnumList));
            this.runBgScreening(bgUserIdnumList);
        }
    }

    @Transactional
    public void runIntervals() {
        List intervalsUserList = this.bgScreeningUserService.findIntervalsUser(this.screeningConfig.getScheduled().getTimingDay().intValue(), this.screeningConfig.getScheduled().getTimingCount().intValue());
        if (CollectionUtil.isEmpty((Collection)intervalsUserList)) {
            log.info("\u6267\u884c\u5b9a\u671f\u80cc\u7b5b\uff0c\u4eba\u6570\u4e3a0\uff0c\u4e0d\u6267\u884c");
        } else {
            List bgUserIdnumList = intervalsUserList.stream().map(BgScreeningUser::getIdnum).collect(Collectors.toList());
            log.info("\u6267\u884c\u5b9a\u671f\u80cc\u7b5b\uff0c\u4eba\u6570\uff1a{}\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}", (Object)bgUserIdnumList.size(), (Object)JSONObject.toJSONString(bgUserIdnumList));
            this.runBgScreening(bgUserIdnumList);
        }
    }

    @Transactional
    public void runManual(List<String> bgUserIdnumList) {
        log.info("\u6267\u884c\u624b\u52a8\u80cc\u7b5b\uff0c\u4eba\u6570\uff1a{}\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}", (Object)bgUserIdnumList.size(), (Object)JSONObject.toJSONString(bgUserIdnumList));
        this.runBgScreening(bgUserIdnumList);
    }

    private void runBgScreening(List<String> bgUserIdnumList) {
        BgScreeningStrategy bgScreeningStrategy = BgScreeningStrategyFactory.getBYServerKey((String)this.screeningConfig.getServerKey());
        List resultDtoList = bgScreeningStrategy.executeBgScreening(new BgScreeningParams(this.screeningConfig.getApi(), bgUserIdnumList));
        log.info("\u80cc\u7b5b\u6bd4\u5bf9\u5b8c\u6210\uff0c\u80cc\u7b5b\u4eba\u6570\uff1a{}\uff0c\u6bd4\u5bf9\u7ed3\u679c\u6570\uff1a{}", (Object)bgUserIdnumList.size(), (Object)resultDtoList.size());
        this.saveBgScreeningResult(resultDtoList);
    }

    private void saveBgScreeningResult(List<BgScreeningResultDto> resultDtoList) {
        log.info("\u6267\u884c\u4fdd\u5b58\u80cc\u7b5b\u7ed3\u679c");
        if (CollectionUtil.isNotEmpty(resultDtoList)) {
            Date now = new Date();
            List resultIdnumList = resultDtoList.stream().map(BgScreeningResultDto::getIdnum).collect(Collectors.toList());
            List bgScreeningUserList = this.bgScreeningUserService.findByIdnumList(resultIdnumList);
            log.info("\u9700\u8981\u66f4\u65b0\u7684\u80cc\u7b5b\u7528\u6237\u6570\u91cf\uff1a{}", (Object)bgScreeningUserList.size());
            Map<String, List<BgScreeningUser>> bgScreeningUserListMap = bgScreeningUserList.stream().collect(Collectors.groupingBy(BgScreeningUser::getIdnum));
            ArrayList questionIdnumList = new ArrayList();
            this.updateBgUserResult(resultDtoList, now, bgScreeningUserListMap, questionIdnumList);
            log.info("\u80cc\u7b5b\u662f\u95ee\u9898\u4eba\u5458\u7684\u6570\u91cf\uff1a{}", (Object)questionIdnumList.size());
            if (CollectionUtil.isNotEmpty(questionIdnumList)) {
                List employeesList = this.employeesService.findByItemDocumentIdList(questionIdnumList);
                log.info("\u67e5\u8be2\u51fa\u804c\u5458\u7684\u6570\u91cf\uff1a{}", (Object)employeesList.size());
                if (CollectionUtil.isNotEmpty((Collection)employeesList)) {
                    Map<String, List<Employees>> employeesListMap = employeesList.stream().collect(Collectors.groupingBy(Employees::getIdNo));
                    Map existBgUserResultMap = this.getExistBgResultMap(questionIdnumList);
                    ArrayList updateBgResultList = new ArrayList();
                    ArrayList insertBgResultList = new ArrayList();
                    this.executeResultCompare(resultDtoList, now, employeesListMap, existBgUserResultMap, updateBgResultList, insertBgResultList);
                    log.info("\u66f4\u65b0\u80cc\u7b5b\u95ee\u9898\u8bb0\u5f55\u8868\u6570\u91cf\uff1a{}", (Object)updateBgResultList.size());
                    this.bgScreeningUserResultService.updateBatchById(updateBgResultList);
                    log.info("\u65b0\u589e\u80cc\u7b5b\u95ee\u9898\u8bb0\u5f55\u8868\u6570\u91cf\uff1a{}", (Object)insertBgResultList.size());
                    this.bgScreeningUserResultService.saveBatch(insertBgResultList);
                }
            }
            log.info("\u66f4\u65b0\u80cc\u7b5b\u7528\u6237\u8868\u6570\u91cf\uff1a{}", (Object)bgScreeningUserList.size());
            this.bgScreeningUserService.updateBatchById((Collection)bgScreeningUserList);
            ArrayList<BgScreeningUserExecLog> logList = new ArrayList<BgScreeningUserExecLog>();
            for (BgScreeningResultDto resultDto : resultDtoList) {
                List<BgScreeningUser> bgUserList = bgScreeningUserListMap.get(resultDto.getIdnum());
                if (!CollectionUtil.isNotEmpty(bgUserList)) continue;
                for (BgScreeningUser bgScreeningUser : bgUserList) {
                    logList.add(resultDto.getBgScreeningUserExecLog(now, bgScreeningUser.getPkId()));
                }
            }
            log.info("\u751f\u6210\u80cc\u7b5b\u65e5\u5fd7\u6570\u91cf\uff1a{}", (Object)logList.size());
            this.bgScreeningUserExecLogService.saveBatch(logList);
        }
    }

    private void executeResultCompare(List<BgScreeningResultDto> resultDtoList, Date now, Map<String, List<Employees>> employeesListMap, Map<String, BgScreeningUserResult> existBgUserResultMap, List<BgScreeningUserResult> updateBgResultList, List<BgScreeningUserResult> insertBgResultList) {
        log.info("\u6267\u884c\u7ed3\u679c\u6bd4\u5bf9");
        for (BgScreeningResultDto resultDto : resultDtoList) {
            if (!CollectionUtil.isNotEmpty((Collection)resultDto.getQuestionType())) continue;
            log.info("\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}\uff0c\u80cc\u7b5b\u95ee\u9898\u7c7b\u578b\uff1a{}", (Object)resultDto.getIdnum(), (Object)resultDto.getQuestionType());
            List<Employees> employeesList = employeesListMap.get(resultDto.getIdnum());
            log.info("\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}\uff0c\u804c\u5458\u8868\u6570\u91cf\uff1a{}", (Object)resultDto.getIdnum(), (Object)(employeesList == null ? 0 : employeesList.size()));
            if (!CollectionUtil.isNotEmpty(employeesList)) continue;
            for (Integer questionType : resultDto.getQuestionType()) {
                for (Employees employees : employeesList) {
                    String key = this.getQuestionMapKey(resultDto.getIdnum(), employees.getItemDomainId(), questionType.toString());
                    BgScreeningUserResult userResult = existBgUserResultMap.get(key);
                    if (userResult != null && employees.getHireDate() != null && userResult.getCreated().after(employees.getHireDate())) {
                        log.info("\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}\uff0c\u5df2\u5b58\u5728\u5165\u804c\u4e4b\u540e\u7684\u95ee\u9898\u7c7b\u578b\uff0c\u53ea\u9700\u8981\uff1a\u80cc\u7b5b\u6b21\u6570+1", (Object)resultDto.getIdnum());
                        int oldCount = userResult.getScreeningCount() == null ? 1 : userResult.getScreeningCount();
                        userResult.setScreeningCount(Integer.valueOf(oldCount + 1));
                        if (StringUtils.isBlank((CharSequence)userResult.getRegisterPoliceAddressId())) {
                            userResult.setRegisterPoliceAddress(employees.getSuperviseOffice());
                            userResult.setRegisterPoliceAddressId(employees.getSuperviseOfficeCode());
                        }
                        updateBgResultList.add(userResult);
                        continue;
                    }
                    log.info("\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a{}\uff0c\u6ca1\u6709\u8bb0\u5f55 || \u8bb0\u5f55\u5728\u5165\u804c\u4e4b\u524d\uff0c\u9700\u8981\u65b0\u589e\u95ee\u9898\u8bb0\u5f55", (Object)resultDto.getIdnum());
                    insertBgResultList.add(this.createNewBgResult(now, resultDto, questionType, employees));
                }
            }
        }
        log.info("\u6267\u884c\u7ed3\u679c\u6bd4\u5bf9\u7ed3\u675f");
    }

    private Map<String, BgScreeningUserResult> getExistBgResultMap(List<String> questionIdnumList) {
        HashMap<String, BgScreeningUserResult> bgUserResultMap = new HashMap<String, BgScreeningUserResult>();
        List bgUserResultList = this.bgScreeningUserResultService.findByIdnumList(questionIdnumList);
        log.info("\u67e5\u8be2\u51fa\u5df2\u5b58\u5728\u7684\u95ee\u9898\u5217\u8868\u7684\u6570\u91cf\uff1a{}", (Object)bgUserResultList.size());
        if (CollectionUtil.isNotEmpty((Collection)bgUserResultList)) {
            for (BgScreeningUserResult bgUserResult : bgUserResultList) {
                String key = this.getQuestionMapKey(bgUserResult.getDocumentId(), bgUserResult.getCompanyId(), bgUserResult.getType().toString());
                bgUserResultMap.put(key, bgUserResult);
            }
        }
        return bgUserResultMap;
    }

    private BgScreeningUserResult createNewBgResult(Date now, BgScreeningResultDto resultDto, Integer questionType, Employees employees) {
        BgScreeningUserResult bgScreeningUserResult = new BgScreeningUserResult();
        bgScreeningUserResult.setId(UUID.randomUUID().toString());
        bgScreeningUserResult.setType(questionType);
        bgScreeningUserResult.setCreated(now);
        bgScreeningUserResult.setLastModified(now);
        bgScreeningUserResult.setFirstCompareTime(now);
        bgScreeningUserResult.setCompareTime(now);
        bgScreeningUserResult.setDomainId(employees.getDomainId());
        bgScreeningUserResult.setQuestionType(resultDto.getProblemDetail());
        bgScreeningUserResult.setUserId(employees.getUserId());
        bgScreeningUserResult.setSecurityName(employees.getName());
        bgScreeningUserResult.setDocumentId(resultDto.getIdnum());
        bgScreeningUserResult.setPhone(employees.getPhone());
        bgScreeningUserResult.setCompanyName(employees.getCompanyName());
        bgScreeningUserResult.setCompanyId(employees.getItemDomainId());
        bgScreeningUserResult.setRegisterPoliceAddress(employees.getSuperviseOffice());
        bgScreeningUserResult.setRegisterPoliceAddressId(employees.getSuperviseOfficeCode());
        bgScreeningUserResult.setPoliceStatus("0");
        bgScreeningUserResult.setWorkStatus("1");
        bgScreeningUserResult.setCompanyStatus("0");
        bgScreeningUserResult.setEntryTime(employees.getHireDate());
        bgScreeningUserResult.setCaptureStatus(questionType == 1 ? Integer.valueOf(0) : null);
        bgScreeningUserResult.setScreeningCount(Integer.valueOf(1));
        return bgScreeningUserResult;
    }

    private void updateBgUserResult(List<BgScreeningResultDto> resultDtoList, Date now, Map<String, List<BgScreeningUser>> bgScreeningUserListMap, List<String> questionIdnumList) {
        for (BgScreeningResultDto resultDto : resultDtoList) {
            List<BgScreeningUser> bgScreeningUserList;
            if (resultDto.getIsProblem().booleanValue()) {
                questionIdnumList.add(resultDto.getIdnum());
            }
            if (!CollectionUtil.isNotEmpty(bgScreeningUserList = bgScreeningUserListMap.get(resultDto.getIdnum()))) continue;
            for (BgScreeningUser bgScreeningUser : bgScreeningUserList) {
                bgScreeningUser.setBackgroundScreeningStatus(resultDto.getBgStatus());
                bgScreeningUser.setLastBackgroundScreeningTime(now);
                bgScreeningUser.setLastBgScreeningResultStatus(Integer.valueOf(resultDto.getBgResultType()));
                bgScreeningUser.setLastBgScreeningResult(resultDto.getBgResult());
                bgScreeningUser.setLastModifiedTime(now);
            }
        }
    }

    private String getQuestionMapKey(String idnum, String companyId, String questionType) {
        return idnum.concat("-").concat(companyId).concat("-").concat(questionType);
    }
}

