/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.dtos.bg;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.backend.entity.BgScreeningUserExecLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BgScreeningResultDto {
    private String idnum;
    private Boolean isProblem;
    private List<String> problemDetailList;
    private String apiResult;

    public Integer getBgStatus() {
        if (this.isProblem.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public String getProblemDetail() {
        if (CollectionUtil.isNotEmpty((Collection)this.problemDetailList)) {
            return String.join((CharSequence)",", this.problemDetailList);
        }
        return "";
    }

    public Set<Integer> getQuestionType() {
        HashSet<Integer> result = new HashSet<Integer>();
        if (this.isProblem.booleanValue() && CollectionUtil.isNotEmpty((Collection)this.problemDetailList)) {
            ArrayList<String> zdList = new ArrayList<String>();
            for (String detail : this.problemDetailList) {
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u5438\u6bd2") || StringUtils.contains((CharSequence)detail, (CharSequence)"\u6212\u6bd2")) {
                    result.add(2);
                    continue;
                }
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u5728\u9003")) {
                    result.add(1);
                    continue;
                }
                zdList.add(detail);
            }
            if (CollectionUtil.isEmpty(result) || CollectionUtil.isNotEmpty(zdList)) {
                result.add(3);
            }
        }
        return result;
    }

    public int getBgResultType() {
        int result = 0;
        if (this.isProblem.booleanValue() && CollectionUtil.isNotEmpty((Collection)this.problemDetailList)) {
            ArrayList<String> zdList = new ArrayList<String>();
            for (String detail : this.problemDetailList) {
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u5438\u6bd2") || StringUtils.contains((CharSequence)detail, (CharSequence)"\u6212\u6bd2")) {
                    result = (int)((double)result + Math.pow(2.0, 1.0));
                    continue;
                }
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u5728\u9003")) {
                    result = (int)((double)result + Math.pow(2.0, 0.0));
                    continue;
                }
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u7cbe\u795e\u75c5")) {
                    result = (int)((double)result + Math.pow(2.0, 3.0));
                    continue;
                }
                zdList.add(detail);
            }
            if (result == 0 || CollectionUtil.isNotEmpty(zdList)) {
                result = (int)((double)result + Math.pow(2.0, 2.0));
            }
        }
        return result;
    }

    public String getBgResult() {
        StringBuffer result = new StringBuffer();
        if (this.isProblem.booleanValue() && CollectionUtil.isNotEmpty((Collection)this.problemDetailList)) {
            ArrayList<String> zdList = new ArrayList<String>();
            for (String detail : this.problemDetailList) {
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u5438\u6bd2") || StringUtils.contains((CharSequence)detail, (CharSequence)"\u6212\u6bd2")) {
                    result.append("\u5438\u6bd2\uff0c");
                    continue;
                }
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u5728\u9003")) {
                    result.append("\u5728\u9003\uff0c");
                    continue;
                }
                if (StringUtils.contains((CharSequence)detail, (CharSequence)"\u7cbe\u795e\u75c5")) {
                    result.append("\u7cbe\u795e\u75c5\uff0c");
                    continue;
                }
                zdList.add(detail);
            }
            if (result.toString().equals("") || CollectionUtil.isNotEmpty(zdList)) {
                result.append("\u91cd\u70b9\uff0c");
            }
        }
        return result.toString();
    }

    public BgScreeningUserExecLog getBgScreeningUserExecLog(Date now, Long bgUserId) {
        BgScreeningUserExecLog log = new BgScreeningUserExecLog();
        log.setType(Integer.valueOf(2));
        log.setCreatedTime(now);
        log.setIdnum(this.idnum);
        log.setShortResult(this.getProblemDetail());
        log.setResult(this.apiResult);
        log.setQuestionType(Integer.valueOf(this.getBgResultType()));
        log.setBgUserId(bgUserId);
        return log;
    }

    public String getIdnum() {
        return this.idnum;
    }

    public Boolean getIsProblem() {
        return this.isProblem;
    }

    public List<String> getProblemDetailList() {
        return this.problemDetailList;
    }

    public String getApiResult() {
        return this.apiResult;
    }

    public void setIdnum(String idnum) {
        this.idnum = idnum;
    }

    public void setIsProblem(Boolean isProblem) {
        this.isProblem = isProblem;
    }

    public void setProblemDetailList(List<String> problemDetailList) {
        this.problemDetailList = problemDetailList;
    }

    public void setApiResult(String apiResult) {
        this.apiResult = apiResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BgScreeningResultDto)) {
            return false;
        }
        BgScreeningResultDto other = (BgScreeningResultDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isProblem = this.getIsProblem();
        Boolean other$isProblem = other.getIsProblem();
        if (this$isProblem == null ? other$isProblem != null : !((Object)this$isProblem).equals(other$isProblem)) {
            return false;
        }
        String this$idnum = this.getIdnum();
        String other$idnum = other.getIdnum();
        if (this$idnum == null ? other$idnum != null : !this$idnum.equals(other$idnum)) {
            return false;
        }
        List this$problemDetailList = this.getProblemDetailList();
        List other$problemDetailList = other.getProblemDetailList();
        if (this$problemDetailList == null ? other$problemDetailList != null : !((Object)this$problemDetailList).equals(other$problemDetailList)) {
            return false;
        }
        String this$apiResult = this.getApiResult();
        String other$apiResult = other.getApiResult();
        return !(this$apiResult == null ? other$apiResult != null : !this$apiResult.equals(other$apiResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BgScreeningResultDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isProblem = this.getIsProblem();
        result = result * 59 + ($isProblem == null ? 43 : ((Object)$isProblem).hashCode());
        String $idnum = this.getIdnum();
        result = result * 59 + ($idnum == null ? 43 : $idnum.hashCode());
        List $problemDetailList = this.getProblemDetailList();
        result = result * 59 + ($problemDetailList == null ? 43 : ((Object)$problemDetailList).hashCode());
        String $apiResult = this.getApiResult();
        result = result * 59 + ($apiResult == null ? 43 : $apiResult.hashCode());
        return result;
    }

    public String toString() {
        return "BgScreeningResultDto(idnum=" + this.getIdnum() + ", isProblem=" + this.getIsProblem() + ", problemDetailList=" + this.getProblemDetailList() + ", apiResult=" + this.getApiResult() + ")";
    }
}

