/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import java.io.UnsupportedEncodingException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import sun.misc.BASE64Encoder;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static String lowerFirst(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String upperFirst(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String replaceHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static String abbr(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : StringUtils.replaceHtml(StringEscapeUtils.unescapeHtml4((String)str)).toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("GBK").length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String rabbr(String str, int length) {
        return StringUtils.abbr(StringUtils.replaceHtml(str), length);
    }

    public static Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(StringUtils.toDouble(val).floatValue());
    }

    public static Long toLong(Object val) {
        return StringUtils.toDouble(val).longValue();
    }

    public static Integer toInteger(Object val) {
        return StringUtils.toLong(val).intValue();
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String encodeBase64(byte[] data) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static String bytes2Hex(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String tmp = null;
        for (byte b : bytes) {
            tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                tmp = "0" + tmp;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static String OnlyFilterOutNumbers(String str) {
        StringBuilder result = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) < '0' || str.charAt(i) > '9') continue;
            result.append(str.charAt(i));
        }
        return result.toString();
    }
}

