/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.signature.service.SignatureToPDFService;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SignatureToPDFServiceImpl
implements SignatureToPDFService {
    private static final Logger log = LoggerFactory.getLogger(SignatureToPDFServiceImpl.class);
    private final SignatureQueuesRepository signatureQueuesRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Value(value="${myapps.signature.mobanPDF}")
    String mobanPDF;
    @Value(value="${myapps.signature.cgiApi}")
    String cgiApi;
    @Autowired
    private ConvertServiceImpl convertService;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    public SignatureToPDFServiceImpl(SignatureQueuesRepository signatureQueuesRepository) {
        this.signatureQueuesRepository = signatureQueuesRepository;
    }

    @Override
    public void cerPDF() {
        this.createPDF();
    }

    private boolean activateXMPSignQuicklyExCGI() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject json = new JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001009256");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in");
            json.put("out", (Object)"/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", (Object)405);
            pos.put("centerY", (Object)312);
            pos.put("page", (Object)1);
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            String ret = HttpUtil.post((String)this.cgiApi, (String)json.toJSONString());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return false;
            }
            JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            return "1".equals(String.valueOf(result.get((Object)"code")));
        }
        catch (Exception e) {
            log.info("====> xxxxxxxx \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI message:" + e.getMessage());
            return false;
        }
    }

    private void createPDF() {
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueues(0, PageRequest.of((int)0, (int)300));
        List queues = pageQueues.getContent();
        if (Collections.isEmpty((Collection)queues)) {
            return;
        }
        for (SignatureQueuesDTO queuesDTO : queues) {
            this.accept(queuesDTO);
        }
    }

    private void accept(SignatureQueuesDTO queue) {
        Long a = System.currentTimeMillis();
        SignatureData data = (SignatureData)JSONObject.parseObject((String)queue.getData(), SignatureData.class);
        data.setUnSignaturePDF(this.tempPDF + "/" + System.currentTimeMillis() + "queueId_" + queue.getId() + ".temp");
        String toDay = data.getFzDate();
        if (StringUtils.isEmpty((CharSequence)toDay)) {
            toDay = DateUtil.today();
        }
        data.setZYear(toDay.split("-")[0]);
        data.setZMonth(toDay.split("-")[1]);
        data.setZDay(toDay.split("-")[2]);
        data.setHeadphoto(data.getHeadphoto().startsWith("http") ? data.getHeadphoto() : this.urlHead + data.getHeadphoto());
        String result = "";
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(queue.getTemplate_url());
        sharedConvertDto.setFormData(data);
        if (!SignatureToPDFServiceImpl.doesFileExist(data.getHeadphoto())) {
            this.signatureQueuesRepository.updateSignature(2, new Date(), "PDF\u751f\u6210\u5931\u8d25\uff1a\u65e0\u5934\u50cf\u4fe1\u606f", queue.getId());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a002\uff1afail\uff1a\u65e0\u5934\u50cf\u4fe1\u606f");
        }
        try {
            result = this.convertService.execConvertHtmltopdfForTemp(sharedConvertDto);
        }
        catch (IOException e) {
            result = "";
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.signatureQueuesRepository.updateSignature(3, new Date(), "PDF\u5df2\u751f\u6210\u5f85\u7b7e\u7ae0", queue.getId());
        } else {
            this.signatureQueuesRepository.updateSignature(2, new Date(), "PDF\u751f\u6210\u5931\u8d25", queue.getId());
        }
        log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u751f\u6210\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    /*
     * Exception decompiling
     */
    public static boolean doesFileExist(String urlString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void delInPDF() {
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(this.tempPDF);
        this.convertService.delInPDF(sharedConvertDto);
    }

    @Override
    public void signQuicklyExCGI() {
        Long a = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tempUrl", (Object)this.tempPDF);
        jsonObject.put("formData", (Object)230);
        try {
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            String tempUrl = jsonObject.getString("tempUrl");
            String formData = jsonObject.getString("formData");
            sharedConvertDto.setTempUrl(tempUrl);
            sharedConvertDto.setFormData(formData);
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u524d\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            this.convertService.existsPdfCopy(sharedConvertDto);
            this.convertService.delInPDF(this.tempPDF);
            this.activateXMPSignQuicklyExCGI();
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u540e\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.\u7b7e\u7ae0\u63a5\u53e3\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeStatus() {
        String updateSql = "update obpm2_security.signature_queues set status = '0' where status = '3' and TIMESTAMPDIFF(HOUR, last_processed_time, NOW()) > 3";
        this.jdbcTemplate.update(updateSql);
    }

    @Override
    public void scan() {
        StringBuilder sb = new StringBuilder();
        try {
            List<Long> failS;
            Long a = System.currentTimeMillis();
            JSONObject jsonObject = new JSONObject();
            String pdfFile = "/uploads/pdf/dianziqianzhang/out";
            jsonObject.put("tempUrl", (Object)pdfFile);
            jsonObject.put("formData", null);
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            sharedConvertDto.setTempUrl(pdfFile);
            sharedConvertDto.setFormData(null);
            String result = this.convertService.existsScanSignature(sharedConvertDto);
            if (StringUtils.isEmpty((CharSequence)result)) {
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.result\uff1a\u7a7a");
                return;
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.\u6279\u91cf\u4e0a\u4f20ftp\u7ed3\u675f\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
            JSONObject json = JSONObject.parseObject((String)result);
            Object success = json.get((Object)"success");
            Object fail = json.get((Object)"fail");
            List<Long> failList = null;
            String successFile = "";
            String failFile = "";
            if (success != null) {
                successFile = (String)success;
            }
            if (fail != null && StringUtils.isNotEmpty((CharSequence)(failFile = (String)fail)) && (failS = Arrays.stream(failFile.replace(".pdf", "").split("queueId_")[1].split(",")).map(ii -> Long.parseLong(ii)).collect(Collectors.toList())).size() > 0) {
                failList = failS;
            }
            String fileNames = successFile + failFile;
            new Thread(() -> {
                try {
                    this.convertService.delSetFtpFile(this.tempPDF, fileNames);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.ftp\u64cd\u4f5c\u8fc7\u7684\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            if (StringUtils.isNotEmpty((CharSequence)successFile)) {
                String[] successSplit;
                for (String string : successSplit = successFile.split(",")) {
                    String successFilePath = pdfFile + "/" + string;
                    Long id = Long.parseLong(string.split("queueId_")[1].replace(".pdf", ""));
                    String business_id = this.signatureQueuesRepository.getBuId(id);
                    String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"2\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_CERTIFICATEDATE=IFNULL(ITEM_CERTIFICATEDATE,NOW()),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u5b8c\u6210\",ITEM_ATTACHMENT=\"" + successFilePath + "\" WHERE ID=\"" + business_id + "\";";
                    this.jdbcTemplate.update(updateSql);
                    this.signatureQueuesRepository.updateSignature(1, new Date(), "\u6210\u529f", id);
                }
            }
            if (failList != null) {
                this.signatureQueuesRepository.updateSignatures(2, new Date(), "\u672a\u6210\u529f\u7b7e\u7ae0", failList);
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.50\u4e2aPDF\u5df2\u7b7e\u7ae0\u6587\u4ef6\u5b58FTP\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.updateSql error\uff1a" + ExceptionUtils.getStackMessage((Throwable)e));
        }
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureToPDFServiceImpl.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureToPDFServiceImpl.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

