/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.ios;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.getui.GetuiPush;
import cn.wildfirechat.push.ios.ApnsServer;
import cn.wildfirechat.push.ios.IOSPushService;
import com.google.gson.Gson;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IOSPushServiceImpl
implements IOSPushService {
    private static final Logger LOG = LoggerFactory.getLogger(IOSPushServiceImpl.class);
    @Autowired
    public ApnsServer apnsServer;
    @Autowired
    private GetuiPush getuiPush;
    private ExecutorService executorService = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 100, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public Object push(PushMessage pushMessage) {
        LOG.info("iOS push {}", (Object)new Gson().toJson((Object)pushMessage));
        if (Utility.filterPush((PushMessage)pushMessage)) {
            LOG.info("canceled");
            return "Canceled";
        }
        long start = System.currentTimeMillis();
        this.executorService.execute(() -> {
            long now = System.currentTimeMillis();
            if (now - start > 15000L) {
                LOG.error("\u7b49\u5f85\u592a\u4e45\uff0c\u6d88\u606f\u629b\u5f03");
                return;
            }
            if (pushMessage.pushType < 3) {
                this.apnsServer.pushMessage(pushMessage);
            } else if (pushMessage.pushType == 7) {
                this.getuiPush.push(pushMessage, false);
            } else {
                LOG.error("Unknown ios push type: {}", (Object)pushMessage.pushType);
            }
        });
        return "OK";
    }
}

