/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.ios;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.ios.ApnsConfig;
import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientBuilder;
import com.turo.pushy.apns.ApnsClientMetricsListener;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.PushType;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.metrics.micrometer.MicrometerApnsClientMetricsListener;
import com.turo.pushy.apns.util.ApnsPayloadBuilder;
import com.turo.pushy.apns.util.SimpleApnsPushNotification;
import com.turo.pushy.apns.util.concurrent.PushNotificationFuture;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ApnsServer {
    private static final Logger LOG = LoggerFactory.getLogger(ApnsServer.class);
    final SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
    final MicrometerApnsClientMetricsListener productMetricsListener = new MicrometerApnsClientMetricsListener((MeterRegistry)this.meterRegistry, new String[]{"notifications", "apns_product"});
    final MicrometerApnsClientMetricsListener developMetricsListener = new MicrometerApnsClientMetricsListener((MeterRegistry)this.meterRegistry, new String[]{"notifications", "apns_develop"});
    ApnsClient productSvc;
    ApnsClient developSvc;
    ApnsClient productVoipSvc;
    ApnsClient developVoipSvc;
    @Autowired
    private ApnsConfig mConfig;

    @PostConstruct
    private void init() {
        if (StringUtils.isEmpty((Object)this.mConfig.alert)) {
            this.mConfig.alert = "default";
        }
        if (StringUtils.isEmpty((Object)this.mConfig.voipAlert)) {
            this.mConfig.alert = "default";
        }
        try {
            if (!(StringUtils.isEmpty((Object)this.mConfig.authKeyPath) || StringUtils.isEmpty((Object)this.mConfig.keyId) || StringUtils.isEmpty((Object)this.mConfig.teamId))) {
                this.productSvc = new ApnsClientBuilder().setApnsServer("api.push.apple.com").setSigningKey(ApnsSigningKey.loadFromPkcs8File((File)new File(this.mConfig.authKeyPath), (String)this.mConfig.teamId, (String)this.mConfig.keyId)).setMetricsListener((ApnsClientMetricsListener)this.productMetricsListener).build();
                this.developSvc = new ApnsClientBuilder().setApnsServer("api.development.push.apple.com").setSigningKey(ApnsSigningKey.loadFromPkcs8File((File)new File(this.mConfig.authKeyPath), (String)this.mConfig.teamId, (String)this.mConfig.keyId)).setMetricsListener((ApnsClientMetricsListener)this.developMetricsListener).build();
                if (this.mConfig.voipFeature) {
                    this.productVoipSvc = new ApnsClientBuilder().setApnsServer("api.push.apple.com").setSigningKey(ApnsSigningKey.loadFromPkcs8File((File)new File(this.mConfig.authKeyPath), (String)this.mConfig.teamId, (String)this.mConfig.keyId)).setMetricsListener((ApnsClientMetricsListener)this.productMetricsListener).build();
                    this.developVoipSvc = new ApnsClientBuilder().setApnsServer("api.development.push.apple.com").setSigningKey(ApnsSigningKey.loadFromPkcs8File((File)new File(this.mConfig.authKeyPath), (String)this.mConfig.teamId, (String)this.mConfig.keyId)).setMetricsListener((ApnsClientMetricsListener)this.developMetricsListener).build();
                }
            } else {
                this.productSvc = new ApnsClientBuilder().setApnsServer("api.push.apple.com").setClientCredentials(new File(this.mConfig.cerPath), this.mConfig.cerPwd).setMetricsListener((ApnsClientMetricsListener)this.productMetricsListener).build();
                this.developSvc = new ApnsClientBuilder().setApnsServer("api.development.push.apple.com").setClientCredentials(new File(this.mConfig.cerPath), this.mConfig.cerPwd).setMetricsListener((ApnsClientMetricsListener)this.developMetricsListener).build();
                if (this.mConfig.voipFeature) {
                    this.productVoipSvc = new ApnsClientBuilder().setApnsServer("api.push.apple.com").setClientCredentials(new File(this.mConfig.voipCerPath), this.mConfig.voipCerPwd).setMetricsListener((ApnsClientMetricsListener)this.productMetricsListener).build();
                    this.developVoipSvc = new ApnsClientBuilder().setApnsServer("api.development.push.apple.com").setClientCredentials(new File(this.mConfig.voipCerPath), this.mConfig.voipCerPwd).setMetricsListener((ApnsClientMetricsListener)this.developMetricsListener).build();
                }
            }
        }
        catch (Exception e) {
            LOG.error("ApnsServer init failed");
            e.printStackTrace();
        }
    }

    public long getMessageId(PushMessage pushMessage) {
        try {
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(pushMessage.pushData);
            if (jsonObject.get((Object)"messageUid") instanceof Long) {
                return (Long)jsonObject.get((Object)"messageUid");
            }
            if (jsonObject.get((Object)"messageUid") instanceof Integer) {
                return ((Integer)jsonObject.get((Object)"messageUid")).intValue();
            }
            if (jsonObject.get((Object)"messageUid") instanceof Double) {
                double uid = (Double)jsonObject.get((Object)"messageUid");
                return (long)uid;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public void pushMessage(PushMessage pushMessage) {
        SimpleApnsPushNotification pushNotification;
        String payload;
        ApnsClient service;
        String sound = this.mConfig.alert;
        String collapseId = null;
        if (pushMessage.messageId > 0L) {
            collapseId = pushMessage.messageId + "";
        }
        if (pushMessage.pushMessageType == 1) {
            sound = this.mConfig.voipAlert;
        } else if (pushMessage.pushMessageType == 2 || pushMessage.pushMessageType == 4) {
            sound = null;
        } else if (pushMessage.pushMessageType == 5 || pushMessage.pushMessageType == 6) {
            sound = null;
            long messageId = this.getMessageId(pushMessage);
            if (messageId > 0L) {
                collapseId = messageId + "";
            }
        } else if (pushMessage.pushMessageType != 0 && pushMessage.pushMessageType != 7) {
            LOG.error("not support push message type:{}", (Object)pushMessage.pushMessageType);
        }
        int badge = pushMessage.getUnReceivedMsg();
        if (badge <= 0) {
            badge = 1;
        }
        String[] arr = Utility.getPushTitleAndContent((PushMessage)pushMessage);
        String title = arr[0];
        String body = arr[1];
        ApnsPayloadBuilder payloadBuilder = new ApnsPayloadBuilder();
        payloadBuilder.setAlertBody(body);
        payloadBuilder.setAlertTitle(title);
        payloadBuilder.setBadgeNumber(Integer.valueOf(badge));
        payloadBuilder.setSound(sound);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"sender", (Object)pushMessage.sender);
        jsonObject.put((Object)"convType", (Object)pushMessage.convType);
        jsonObject.put((Object)"convTarget", (Object)pushMessage.target);
        jsonObject.put((Object)"convLine", (Object)pushMessage.line);
        jsonObject.put((Object)"contType", (Object)pushMessage.cntType);
        jsonObject.put((Object)"pushData", (Object)pushMessage.pushData);
        payloadBuilder.addCustomProperty("wfc", (Object)jsonObject);
        Calendar c = Calendar.getInstance();
        if (!this.mConfig.voipFeature || pushMessage.pushMessageType != 1) {
            service = pushMessage.getPushType() == 0 ? this.productSvc : this.developSvc;
            if (pushMessage.pushMessageType != 1 || StringUtils.isEmpty((Object)pushMessage.getVoipDeviceToken())) {
                c.add(12, 10);
                payload = payloadBuilder.buildWithDefaultMaximumLength();
                pushNotification = new SimpleApnsPushNotification(pushMessage.deviceToken, pushMessage.packageName, payload, c.getTime(), DeliveryPriority.CONSERVE_POWER, PushType.ALERT, collapseId);
            } else {
                c.add(12, 1);
                payloadBuilder.setContentAvailable(true);
                payloadBuilder.addCustomProperty("voip", (Object)true);
                payloadBuilder.addCustomProperty("voip_type", (Object)pushMessage.pushMessageType);
                payloadBuilder.addCustomProperty("voip_data", (Object)pushMessage.pushData);
                payload = payloadBuilder.buildWithDefaultMaximumLength();
                pushNotification = new SimpleApnsPushNotification(pushMessage.deviceToken, pushMessage.packageName, payload, c.getTime(), DeliveryPriority.IMMEDIATE, PushType.BACKGROUND, collapseId);
            }
        } else {
            service = pushMessage.getPushType() == 0 ? this.productVoipSvc : this.developVoipSvc;
            c.add(12, 1);
            payload = payloadBuilder.buildWithDefaultMaximumLength();
            pushNotification = new SimpleApnsPushNotification(pushMessage.voipDeviceToken, pushMessage.packageName + ".voip", payload, c.getTime(), DeliveryPriority.IMMEDIATE, PushType.VOIP, collapseId);
        }
        SimpleApnsPushNotification simpleApnsPushNotification = pushNotification;
        LOG.info("CollapseId:{}", (Object)simpleApnsPushNotification.getCollapseId());
        if (service == null) {
            LOG.error("Service not exist!!!!");
            return;
        }
        PushNotificationFuture sendNotificationFuture = service.sendNotification((ApnsPushNotification)pushNotification);
        sendNotificationFuture.addListener(future -> {
            if (future.isSuccess()) {
                PushNotificationResponse pushNotificationResponse = (PushNotificationResponse)sendNotificationFuture.getNow();
                if (!pushNotificationResponse.isAccepted()) {
                    LOG.error("apns push failure: {}", (Object)pushNotificationResponse.getRejectionReason());
                } else {
                    LOG.info("push success: {}", (Object)pushNotificationResponse.getApnsId().toString());
                    LOG.info("token invalidate timestamp: {}", (Object)pushNotificationResponse.getTokenInvalidationTimestamp());
                }
            } else {
                future.cause().printStackTrace();
                LOG.error("apns push failure: {}", (Object)future.cause().getLocalizedMessage());
            }
        });
    }
}

