/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.hm;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.hm.HMConfig;
import cn.wildfirechat.push.hm.HMPushService;
import cn.wildfirechat.push.hm.payload.AlertPayload;
import cn.wildfirechat.push.hm.payload.VoipPayload;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HMPushServiceImpl
implements HMPushService {
    private static final String AUD = "https://oauth-login.cloud.huawei.com/oauth2/v3/token";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Logger LOG = LoggerFactory.getLogger(HMPushServiceImpl.class);
    @Autowired
    HMConfig config;
    private String pushUrl;

    @PostConstruct
    void setupPushUrl() {
        this.pushUrl = String.format("https://push-api.cloud.huawei.com/v3/%s/messages:send", this.config.getProjectId());
    }

    private String createJwt() throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPrivateKey prk = (RSAPrivateKey)this.getPrivateKey(this.config.getPrivateKey());
        Algorithm algorithm = Algorithm.RSA256(null, (RSAPrivateKey)prk);
        long iat = System.currentTimeMillis() / 1000L;
        long exp = iat + 3600L;
        JWTCreator.Builder builder = JWT.create().withIssuer(this.config.getIss()).withKeyId(this.config.getKid()).withAudience(new String[]{AUD}).withClaim("iat", Long.valueOf(iat)).withClaim("exp", Long.valueOf(exp));
        String jwt = builder.sign(algorithm);
        return jwt;
    }

    private PrivateKey getPrivateKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(this.decodeBase64(key));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    private byte[] decodeBase64(String key) {
        return Base64.decodeBase64((byte[])key.getBytes(DEFAULT_CHARSET));
    }

    public Object push(PushMessage pushMessage) {
        try {
            String jwt = null;
            jwt = this.createJwt();
            if (pushMessage.pushMessageType == 5 || pushMessage.pushMessageType == 6) {
                return null;
            }
            if (this.config.isSupportVoipPush() && (pushMessage.pushMessageType == 1 || pushMessage.pushMessageType == 2)) {
                VoipPayload voipPayload = VoipPayload.buildAlertPayload((PushMessage)pushMessage);
                String response = this.httpPost(this.pushUrl, jwt, 10, voipPayload.toString(), 10000, 10000);
                LOG.info("Push voip message to {} response {}", (Object)pushMessage.getDeviceToken(), (Object)response);
            } else {
                AlertPayload alertPayload = AlertPayload.buildAlertPayload((PushMessage)pushMessage);
                String response = this.httpPost(this.pushUrl, jwt, 0, alertPayload.toString(), 10000, 10000);
                LOG.info("Push alert message to {} response {}", (Object)pushMessage.getDeviceToken(), (Object)response);
            }
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPost(String httpUrl, String jwt, int pushType, String data, int connectTimeout, int readTimeout) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Authorization", "Bearer " + jwt);
            urlConnection.setRequestProperty("push-type", pushType + "");
            urlConnection.setConnectTimeout(connectTimeout);
            urlConnection.setReadTimeout(readTimeout);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)urlConnection.getContentEncoding());
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }
}

