/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.vivo;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.vivo.VivoConfig;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.server.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VivoPush {
    private static final Logger LOG = LoggerFactory.getLogger(VivoPush.class);
    private long tokenExpiredTime;
    @Autowired
    VivoConfig mConfig;
    private String authToken;

    private void refreshToken() {
        Sender sender = null;
        try {
            sender = new Sender(this.mConfig.getAppSecret());
            Result result = sender.getToken(this.mConfig.getAppId(), this.mConfig.getAppKey());
            this.authToken = result.getAuthToken();
            this.tokenExpiredTime = System.currentTimeMillis() + 43200000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("getToken error" + e.getMessage());
        }
    }

    public void push(PushMessage pushMessage) {
        if (this.tokenExpiredTime <= System.currentTimeMillis()) {
            this.refreshToken();
        }
        Result resultMessage = null;
        try {
            String[] arr = Utility.getPushTitleAndContent((PushMessage)pushMessage);
            String title = arr[0];
            String body = arr[1];
            Sender senderMessage = new Sender(this.mConfig.getAppSecret(), this.authToken);
            Message.Builder builder = new Message.Builder().regId(pushMessage.getDeviceToken()).notifyType(3).title(title).content(body).timeToLive(1000).skipType(1).networkType(-1).requestId(System.currentTimeMillis() + "");
            if (pushMessage.pushMessageType != 0) {
                builder.timeToLive(60);
            } else {
                builder.timeToLive(600);
            }
            resultMessage = senderMessage.sendSingle(builder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("sendSingle error " + e.getMessage());
        }
        if (resultMessage != null) {
            LOG.info("Server response: MessageId: " + resultMessage.getTaskId() + " ErrorCode: " + resultMessage.getResult() + " Reason: " + resultMessage.getDesc());
        }
    }
}

