/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.meizu;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.android.meizu.MeiZuConfig;
import com.meizu.push.sdk.server.IFlymePush;
import com.meizu.push.sdk.server.constant.ResultPack;
import com.meizu.push.sdk.server.model.push.PushResult;
import com.meizu.push.sdk.server.model.push.VarnishedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MeiZuPush {
    private static final Logger LOG = LoggerFactory.getLogger(MeiZuPush.class);
    private IFlymePush flymePush;
    @Autowired
    private MeiZuConfig mConfig;

    @PostConstruct
    public void init() {
        try {
            this.flymePush = new IFlymePush(this.mConfig.getAppSecret());
        }
        catch (Exception e) {
            LOG.error("MeiZuPush init failed");
            e.printStackTrace();
        }
    }

    public void push(PushMessage pushMessage) {
        if (pushMessage.pushMessageType == 5 || pushMessage.pushMessageType == 6) {
            return;
        }
        String title = pushMessage.pushMessageType == 3 ? (StringUtils.isEmpty((Object)pushMessage.senderName) ? "\u597d\u53cb\u8bf7\u6c42" : pushMessage.senderName + " \u8bf7\u6c42\u52a0\u60a8\u4e3a\u597d\u53cb") : (StringUtils.isEmpty((Object)pushMessage.senderName) ? "\u6d88\u606f" : pushMessage.senderName);
        if (pushMessage.pushMessageType == 7) {
            pushMessage.pushContent = "\u60a8\u6536\u5230\u4e00\u6761\u5bc6\u804a\u6d88\u606f";
        }
        VarnishedMessage message = new VarnishedMessage.Builder().appId(Long.valueOf(this.mConfig.getAppId())).title(title).content(pushMessage.pushContent).validTime(1).build();
        ArrayList<String> pushIds = new ArrayList<String>();
        pushIds.add(pushMessage.getDeviceToken());
        try {
            ResultPack result = this.flymePush.pushMessage(message, pushIds);
            if (result.isSucceed()) {
                PushResult pushResult = (PushResult)result.value();
                String msgId = pushResult.getMsgId();
                Map targetResultMap = pushResult.getRespTarget();
                LOG.info("push result:" + pushResult);
                if (targetResultMap != null && !targetResultMap.isEmpty()) {
                    System.err.println("push fail token:" + targetResultMap);
                }
            } else {
                LOG.info(String.format("pushMessage error code:%s comment:%s", result.code(), result.comment()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

