/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.fcm;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.fcm.FCMConfig;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FCMPush {
    private static final Logger LOG = LoggerFactory.getLogger(FCMPush.class);
    @Autowired
    private FCMConfig mConfig;

    @PostConstruct
    private void init() throws Exception {
        try {
            FileInputStream refreshToken = new FileInputStream(this.mConfig.getCredentialsPath());
            FirebaseOptions options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)refreshToken)).setDatabaseUrl("https://<DATABASE_NAME>.firebaseio.com/").build();
            FirebaseApp.initializeApp((FirebaseOptions)options);
        }
        catch (Exception e) {
            LOG.error("FCMPush init failed");
            e.printStackTrace();
        }
    }

    public void push(PushMessage pushMessage) {
        String[] arr = Utility.getPushTitleAndContent((PushMessage)pushMessage);
        String title = arr[0];
        String body = arr[1];
        Notification.Builder builder = Notification.builder().setTitle(title).setBody(body);
        Message message = Message.builder().setNotification(builder.build()).setToken(pushMessage.deviceToken).build();
        try {
            String response = FirebaseMessaging.getInstance().send(message);
            System.out.println("Successfully sent message: " + response);
        }
        catch (FirebaseMessagingException e) {
            e.printStackTrace();
        }
    }
}

