/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.AndroidPushService;
import cn.wildfirechat.push.android.fcm.FCMPush;
import cn.wildfirechat.push.android.getui.GetuiPush;
import cn.wildfirechat.push.android.hms.HMSPush;
import cn.wildfirechat.push.android.meizu.MeiZuPush;
import cn.wildfirechat.push.android.oppo.OppoPush;
import cn.wildfirechat.push.android.vivo.VivoPush;
import cn.wildfirechat.push.android.xiaomi.XiaomiPush;
import com.google.gson.Gson;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AndroidPushServiceImpl
implements AndroidPushService {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidPushServiceImpl.class);
    @Autowired
    private HMSPush hmsPush;
    @Autowired
    private MeiZuPush meiZuPush;
    @Autowired
    private XiaomiPush xiaomiPush;
    @Autowired
    private VivoPush vivoPush;
    @Autowired
    private OppoPush oppoPush;
    @Autowired
    private FCMPush fcmPush;
    @Autowired
    private GetuiPush getuiPush;
    private ExecutorService executorService = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 100, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public Object push(PushMessage pushMessage) {
        LOG.info("Android push {}", (Object)new Gson().toJson((Object)pushMessage));
        if (Utility.filterPush((PushMessage)pushMessage)) {
            LOG.info("canceled");
            return "Canceled";
        }
        if (pushMessage.line == 1) {
            LOG.info("ignore moments messages");
            return "Canceled";
        }
        long start = System.currentTimeMillis();
        this.executorService.execute(() -> {
            long now = System.currentTimeMillis();
            if (now - start > 15000L) {
                LOG.error("\u7b49\u5f85\u592a\u4e45\uff0c\u6d88\u606f\u629b\u5f03");
                return;
            }
            switch (pushMessage.getPushType()) {
                case 1: {
                    this.xiaomiPush.push(pushMessage);
                    break;
                }
                case 2: {
                    this.hmsPush.push(pushMessage);
                    break;
                }
                case 3: {
                    this.meiZuPush.push(pushMessage);
                    break;
                }
                case 4: {
                    this.vivoPush.push(pushMessage);
                    break;
                }
                case 5: {
                    this.oppoPush.push(pushMessage);
                    break;
                }
                case 6: {
                    this.fcmPush.push(pushMessage);
                    break;
                }
                case 7: {
                    this.getuiPush.push(pushMessage, true);
                    break;
                }
                default: {
                    LOG.info("unknown push type");
                }
            }
        });
        return "ok";
    }
}

