/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrSpliter;
import com.bcxin.risk.report.material.dao.MaterialFormOptionDao;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysMaterialOptionUtil {
    @Resource
    private MaterialFormOptionDao materialFormOptionDao;
    private Map<String, Collection<MaterialFormOption>> CACHE_KEY_MATERIAL_OPTION = Maps.newHashMap();

    public String getOptionLabel(String value, String type, String defaultValue) {
        block4: {
            if (!StringUtils.isNotBlank((CharSequence)type) || !StringUtils.isNotBlank((CharSequence)value)) break block4;
            if (type.startsWith("diy") && type.contains("|")) {
                Collection<MaterialFormOption> valueList = this.getOptionList(type);
                for (MaterialFormOption option : valueList) {
                    if (!value.equals(option.getValue())) continue;
                    return option.getName();
                }
            } else {
                Collection<MaterialFormOption> list = this.optionMap().get(type.toUpperCase());
                for (MaterialFormOption option : list) {
                    if (!value.equals(option.getValue())) continue;
                    return option.getName();
                }
            }
        }
        return defaultValue;
    }

    public Collection<MaterialFormOption> getOptionList(String type) {
        if (type.startsWith("diy") && type.contains("|")) {
            List list = StrSpliter.split((String)type, (String)"|", (boolean)true, (boolean)true);
            return this.materialFormOptionDao.selectDIYOptionList((String)list.get(1), (String)list.get(2), (String)list.get(3), (String)list.get(4));
        }
        return this.optionMap().get(type.toUpperCase());
    }

    public Map<String, Collection<MaterialFormOption>> optionMap() {
        if (MapUtil.isNotEmpty(this.CACHE_KEY_MATERIAL_OPTION)) {
            return this.CACHE_KEY_MATERIAL_OPTION;
        }
        List dictList = this.materialFormOptionDao.selectOptionList();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (MaterialFormOption option : dictList) {
            map.put((Object)option.getType().toUpperCase(), (Object)option);
        }
        this.CACHE_KEY_MATERIAL_OPTION = map.asMap();
        return this.CACHE_KEY_MATERIAL_OPTION;
    }
}

