/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import com.alibaba.fastjson.JSON;
import com.bcxin.risk.common.util.WebUtil;
import com.bcxin.risk.log.SysLog;
import com.bcxin.risk.log.SysLogDao;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysLogUtil {
    @Autowired
    private SysLogDao sysLogDao;

    public void saveLog(String msg, String logType, Exception e) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (request != null) {
            String ip = WebUtil.getHost(request);
            String uri = request.getRequestURI();
            String userAgent = request.getHeader("user-agent");
            String method = request.getMethod();
            Map param = request.getParameterMap();
            String paramJson = JSON.toJSON((Object)param).toString();
            SysLog log = new SysLog();
            if (e != null) {
                log.setException(this.getStackMessage(e));
            }
            log.setContent(msg);
            log.setCreateOn(new Date());
            log.setIp(ip);
            log.setReqParam(paramJson);
            log.setUrl(uri);
            log.setUserAgent(userAgent);
            log.setMethod(method);
            log.setLogType(logType);
            this.sysLogDao.save((Object)log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackMessage(Exception e) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            String expMessage;
            e.printStackTrace(new PrintWriter(buf, true));
            String string = expMessage = buf.toString();
            return string;
        }
        catch (Exception ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
        }
    }
}

