/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.esign;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.bcxin.risk.esign.PageBean;
import com.bcxin.risk.esign.PosBean;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class KeyParserHelper {
    private KeyParserHelper() {
    }

    public static Map<String, List<PosBean>> filterKeyMap(JSONObject json, Integer page) {
        HashMap map = Maps.newHashMap();
        if (json == null || json.isEmpty()) {
            return map;
        }
        JSONArray dataArr = json.getJSONArray("data");
        if (dataArr.isEmpty() || dataArr.size() == 0) {
            return map;
        }
        for (int i = 0; i < dataArr.size(); ++i) {
            JSONObject jobj = dataArr.getJSONObject(i);
            String key = jobj.getString("keyword");
            JSONArray posArr = jobj.getJSONArray("positionList");
            ArrayList<PageBean> list = new ArrayList<PageBean>(posArr.size());
            Iterator var4 = posArr.iterator();
            ParserConfig config = ParserConfig.getGlobalInstance();
            while (var4.hasNext()) {
                Object item = var4.next();
                PageBean classItem = (PageBean)TypeUtils.cast(item, PageBean.class, (ParserConfig)config);
                list.add(classItem);
            }
            ArrayList<PageBean> pageList = list;
            Collections.sort(pageList);
            ArrayList<PosBean> posBeanList = new ArrayList<PosBean>();
            for (PageBean pageBean : pageList) {
                posBeanList.addAll(KeyParserHelper.buildPosList(pageBean.getCoordinateList(), pageBean.getPageIndex()));
            }
            map.put(key, posBeanList);
        }
        return map;
    }

    private static List<PosBean> buildPosList(List<PosBean> list, int pageIndex) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        list = list.stream().sorted(Comparator.comparing(PosBean::getPosY).reversed()).filter(s -> {
            s.setPage(pageIndex);
            return true;
        }).collect(Collectors.toList());
        return list;
    }
}

