/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util.cipher;

import com.bcxin.risk.common.util.cipher.Digests;
import com.bcxin.risk.common.util.cipher.Encodes;

public class Sha1Util {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;

    public static String entryptPassword(String plainPassword) {
        String plain = Encodes.unescapeHtml(plainPassword);
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        String plain = Encodes.unescapeHtml(plainPassword);
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
    }

    public static void main(String[] args) {
        String str1 = "abcdefghijklmnabc";
        System.out.println(str1.indexOf("a"));
        System.out.println(str1.indexOf("c", 3));
        System.out.println(str1.indexOf("x"));
    }
}

