/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.obs.OBSUtil;
import com.bcxin.risk.common.oss.OSSServiceExecutor;
import com.bcxin.risk.common.util.BcxinDateUtil;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final String TI = "_t_";
    private static Pattern FilePattern = Pattern.compile("[\\\\/:*?\"<>|]");
    private static final String DEFAULT_UPLOAD_DIR = "upload";
    private static final String DEFAULT_UPLOAD_LINUX = "/data/upload/pss/";

    public static String filenameFilter(String str) {
        return str == null ? null : FilePattern.matcher(str).replaceAll("");
    }

    public static String storeFile(MultipartFile file) {
        String upload_path = ConfigUtil.getValue("materialUpload_path");
        Map<String, String> rMap = FileUtils.saveFile(upload_path, file);
        if (null != rMap) {
            return rMap.get("url");
        }
        throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25:" + file.getOriginalFilename());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload(MultipartFile xFile, String dir, boolean radomFile, String customFileName) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        String fileName = customFileName;
        if (radomFile) {
            String randomNumber = BcxinDateUtil.generatorRadomNumber();
            fileName = randomNumber + "." + fileType;
        }
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.today() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.today() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil();
        try (InputStream inputStream = xFile.getInputStream();){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("huaweiOBSFileUpload:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static Map<String, String> ossFileUpload(MultipartFile materialFile, String directoryName, boolean radomFile, String customFileName) {
        HashMap map = Maps.newHashMap();
        String materialFileName = materialFile.getOriginalFilename();
        String fileType = StringUtils.substringAfterLast((String)materialFileName, (String)".").toLowerCase();
        String fileName = "";
        if (radomFile) {
            String radomNumber = BcxinDateUtil.generatorRadomNumber();
            fileName = radomNumber + "." + fileType;
        } else {
            fileName = customFileName;
        }
        String ossKey = directoryName + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            new Thread(() -> {
                try {
                    ossExecutor.put(ossKey, materialFile.getInputStream(), true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }).start();
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, String> ossFileUpload_sysc(MultipartFile materialFile, String directoryName, boolean radomFile, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String materialFileName = materialFile.getOriginalFilename();
        String fileType = StringUtils.substringAfterLast((String)materialFileName, (String)".").toLowerCase();
        String fileName = "";
        if (radomFile) {
            String radomNumber = BcxinDateUtil.generatorRadomNumber();
            fileName = radomNumber + "." + fileType;
        } else {
            fileName = customFileName;
        }
        String ossKey = directoryName + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            try {
                ossExecutor.put(ossKey, materialFile.getInputStream(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
            }
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static void createZip(String sourcePath, String zipPath) {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipPath);
            zos = new ZipOutputStream((OutputStream)fos);
            zos.setEncoding("utf8");
            FileUtils.writeZip(new File(sourcePath), "", zos);
        }
        catch (FileNotFoundException e) {
            log.error("\u521b\u5efaZIP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                log.error("\u521b\u5efaZIP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static void writeZip(File file, String parentPath, ZipOutputStream zos) {
        if (file.exists()) {
            if (file.isDirectory()) {
                parentPath = parentPath + file.getName() + File.separator;
                File[] files = file.listFiles();
                if (files.length != 0) {
                    for (File f : files) {
                        FileUtils.writeZip(f, parentPath, zos);
                    }
                } else {
                    try {
                        zos.putNextEntry(new ZipEntry(parentPath));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            } else {
                FileInputStream fis = null;
                try {
                    int len;
                    fis = new FileInputStream(file);
                    ZipEntry ze = new ZipEntry(parentPath + file.getName());
                    zos.putNextEntry(ze);
                    byte[] content = new byte[1024];
                    while ((len = fis.read(content)) != -1) {
                        zos.write(content, 0, len);
                        zos.flush();
                    }
                }
                catch (FileNotFoundException e) {
                    log.error("\u521b\u5efaZIP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    log.error("\u521b\u5efaZIP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        log.error("\u521b\u5efaZIP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static String zipFiles(List<String> filePaths, String zipName) {
        byte[] buffer = new byte[1024];
        String strZipPath = zipName;
        try {
            ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(strZipPath));
            ArrayList files = Lists.newArrayList();
            for (String filePath : filePaths) {
                File policyFile;
                if (!StringUtil.isNotEmpty((String)filePath) || !(policyFile = new File(filePath)).exists()) continue;
                files.add(policyFile);
            }
            for (File file : files) {
                int len;
                FileInputStream fis = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                out.setEncoding("utf8");
                while ((len = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
                fis.close();
            }
            out.close();
            for (File file : files) {
                if (!file.isFile() || !file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void downloadFile(String fileName, String downloadName, HttpServletResponse response) {
        try {
            response.setContentType("octets/stream");
            response.addHeader("Content-Type", "text/html; charset=utf-8");
            String downLoadName = new String(downloadName.getBytes("gbk"), "iso8859-1");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
            FileInputStream fileInputStream = new FileInputStream(fileName);
            ServletOutputStream out = response.getOutputStream();
            int i = 0;
            while ((i = fileInputStream.read()) != -1) {
                out.write(i);
            }
            fileInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> saveFile(String uploadPath, MultipartFile multipartFile) {
        if (multipartFile != null && StringUtil.isNotEmpty((String)multipartFile.getOriginalFilename())) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + StringUtil.randomString((int)5) + ".";
                String fileType = Files.getFileExtension((String)multipartFile.getOriginalFilename());
                materialFileName = materialFileName + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(uploadPath + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = "/getResource.do?path=" + dirDate + "/" + materialFileName;
                String targetPath = uploadPath + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                multipartFile.transferTo(targetFile);
                HashMap map = Maps.newHashMap();
                map.put("url", url);
                map.put("key", "local_" + now.getTime());
                log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Map<String, String> saveFileByScale(String uploadPath, MultipartFile multipartFile) {
        if (multipartFile != null && StringUtil.isNotEmpty((String)multipartFile.getOriginalFilename())) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + StringUtil.randomString((int)5) + ".";
                String fileType = Files.getFileExtension((String)multipartFile.getOriginalFilename());
                materialFileName = materialFileName + fileType;
                String scaleName = now.getTime() + StringUtil.randomString((int)5) + "." + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(uploadPath + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = "/getResource.do?path=" + dirDate + "/" + materialFileName;
                String scaleUrl = "/getResource.do?path=" + dirDate + "/" + scaleName;
                String targetPath = uploadPath + dirDate + "/" + materialFileName;
                String scaleNameTargetPath = uploadPath + dirDate + "/" + scaleName;
                File targetFile = new File(targetPath);
                File scaleFile = new File(scaleNameTargetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                multipartFile.transferTo(targetFile);
                BufferedImage image = ImageIO.read(targetFile);
                HashMap map = Maps.newHashMap();
                if (image != null) {
                    FileUtils.compressPictures(targetPath, scaleNameTargetPath, targetFile.length());
                    if (targetFile.length() > scaleFile.length()) {
                        targetFile.delete();
                        map.put("url", scaleUrl);
                    } else {
                        scaleFile.delete();
                        map.put("url", url);
                    }
                } else {
                    map.put("url", url);
                }
                map.put("key", "local_" + now.getTime());
                log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static void compressPictures(String oldPicPath, String newPicPath, Long fileLength) {
        float quality = 1.0f;
        if (fileLength > 102400L && fileLength < 512000L) {
            quality = 0.6f;
        } else if (fileLength > 512000L && fileLength < 1024000L) {
            quality = 0.5f;
        } else if (fileLength > 1024000L && fileLength < 5120000L) {
            quality = 0.3f;
        } else if (fileLength > 10240000L) {
            quality = 0.1f;
        }
        try {
            Thumbnails.of((String[])new String[]{oldPicPath}).scale(1.0).outputQuality(quality).toFile(newPicPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scale(String srcImageFile, String result, float length, boolean flag) {
        float scale = 1.0f;
        if (length > 20000.0f) {
            scale = 1.5f;
        } else if (length > 50000.0f) {
            scale = 2.0f;
        } else if (length > 100000.0f) {
            scale = 3.0f;
        }
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            int width = src.getWidth();
            int height = src.getHeight();
            if (flag) {
                width = (int)((float)width * scale);
                height = (int)((float)height * scale);
            } else {
                width = (int)((float)width / scale);
                height = (int)((float)height / scale);
            }
            Image image = src.getScaledInstance(width, height, 1);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)tag, "JPEG", new File(result));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String saveFile(MultipartFile multipartFile) {
        if (multipartFile != null && StringUtil.isNotEmpty((String)multipartFile.getOriginalFilename())) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + StringUtil.randomString((int)5) + ".";
                String fileType = Files.getFileExtension((String)multipartFile.getOriginalFilename());
                materialFileName = materialFileName + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(ConfigUtil.material() + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = ConfigUtil.webSiteUrl() + "/getResource.do?path=" + dirDate + "/" + materialFileName;
                String targetPath = ConfigUtil.material() + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                multipartFile.transferTo(targetFile);
                log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                return url;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Map<String, String> saveFile(String uploadPath, File file) {
        if (file != null) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + StringUtil.randomString((int)5) + ".";
                String fileType = Files.getFileExtension((String)file.getPath());
                materialFileName = materialFileName + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(uploadPath + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = "/getResource.do?path=" + dirDate + "/" + materialFileName;
                String targetPath = uploadPath + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                Files.copy((File)file, (File)targetFile);
                HashMap map = Maps.newHashMap();
                map.put("url", url);
                map.put("key", "local_" + now.getTime());
                log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static boolean fileUpload(MultipartFile file, String radomfileName, String materialFilePath) {
        boolean flag = true;
        File baseFile = new File(materialFilePath);
        File trainFile = new File(baseFile, radomfileName);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        try {
            file.transferTo(trainFile);
        }
        catch (IllegalStateException e) {
            flag = false;
        }
        catch (IOException e) {
            flag = false;
        }
        return flag;
    }

    public static void deleteFolder(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    FileUtils.deleteFolder(f);
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

    public static List<String> downLoadFromUrl(String urlStr, String fileName, String savePath) {
        ArrayList pathList = Lists.newArrayList();
        try {
            if (StringUtil.isEmpty((String)urlStr)) {
                return Lists.newArrayList();
            }
            if (StringUtil.isNotEmpty((String)fileName)) {
                fileName = fileName.replace("/", "");
            }
            String[] imageValues = urlStr.split("&&");
            int count = 1;
            for (String imageValue : imageValues) {
                String[] splitStr;
                String disposeFileName = fileName;
                String imagePath = "";
                imagePath = imageValue.contains("||") ? ((splitStr = StringUtil.split((String)imageValue, (String)"||")).length >= 3 ? splitStr[1] : urlStr) : imageValue;
                if (count > 1) {
                    disposeFileName = disposeFileName.contains(".") ? disposeFileName.substring(0, disposeFileName.lastIndexOf(".")) + count : disposeFileName + count;
                }
                System.out.println("------------------\u91cd\u65b0\u8ba1\u7b97\u7684name\u662f" + disposeFileName + "------------------");
                if (imagePath.startsWith("http")) {
                    String filePath = FileUtils.download(imagePath, disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length()), savePath);
                    if (StringUtil.isNotEmpty((String)filePath)) {
                        pathList.add(filePath);
                    }
                } else if (imagePath.indexOf("path=") > 0) {
                    String filePath;
                    String web_url = ConfigUtil.webSiteUrl();
                    String PROFILE_ENVI = ConfigResources.PROFILE_ENVI;
                    if (Objects.equals(PROFILE_ENVI, "dev")) {
                        web_url = ConfigResources.DEV_URL;
                    }
                    if (StringUtil.isNotEmpty((String)web_url) && web_url.endsWith("/") && imagePath.endsWith("/")) {
                        web_url = web_url.substring(0, web_url.length() - 1);
                    }
                    if (StringUtil.isNotEmpty((String)(filePath = FileUtils.download(imagePath = web_url + imagePath, disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length()), savePath)))) {
                        pathList.add(filePath);
                    }
                }
                ++count;
            }
            return pathList;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
            return pathList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String download(String urlStr, String fileName, String savePath) {
        FileOutputStream fos = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            byte[] getData = FileUtils.readInputStream(inputStream);
            File saveDir = new File(savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = new File(saveDir + File.separator + fileName);
            fos = new FileOutputStream(file);
            fos.write(getData);
            String filePath = saveDir + "/" + fileName;
            log.info("\u6587\u4ef6\u4e0b\u8f7d\uff0curl\u8def\u5f84[{}]\uff0c\u6587\u4ef6\u8def\u5f84[{}]", (Object)url, (Object)filePath);
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static List<String> filterMultiFilePath(String localFilePath) {
        String[] filePaths;
        ArrayList list = Lists.newArrayList();
        if (StringUtil.isEmpty((String)localFilePath)) {
            return list;
        }
        for (String filePath : filePaths = StringUtils.split((String)localFilePath, (String)"&&")) {
            String localUrl;
            String[] explain;
            if (filePath.indexOf("||") <= -1 || (explain = StringUtils.split((String)filePath, (String)"||")).length < 3 || (localUrl = explain[1]).indexOf("path=") == -1) continue;
            localUrl = localUrl.substring(localUrl.indexOf("path=") + 5, localUrl.length());
            list.add(localUrl);
        }
        return list;
    }

    public static List<String> filterMultiFileUrl(String localFilePath) {
        String[] filePaths;
        ArrayList list = Lists.newArrayList();
        if (StringUtil.isEmpty((String)localFilePath)) {
            return list;
        }
        for (String filePath : filePaths = StringUtils.split((String)localFilePath, (String)"&&")) {
            String[] explain;
            if (filePath.indexOf("||") <= -1 || (explain = StringUtils.split((String)filePath, (String)"||")).length < 3) continue;
            String localUrl = explain[1];
            list.add(localUrl);
        }
        return list;
    }

    public static String filterSingleLocalFilePath(String localFilePath) {
        if (StringUtil.isEmpty((String)localFilePath)) {
            return localFilePath;
        }
        if (localFilePath.indexOf("||") > -1) {
            String[] explain = StringUtils.split((String)localFilePath, (String)"||");
            if (explain.length < 3) {
                return localFilePath;
            }
            return explain[1];
        }
        return localFilePath;
    }

    public static String filterMultiLocalFilePath(String channel, String localFilePath) {
        String[] stringList;
        if (StringUtil.isEmpty((String)localFilePath)) {
            return localFilePath;
        }
        ArrayList files = Lists.newArrayList();
        for (String path : stringList = localFilePath.split("&&")) {
            String newFilePath = FileUtils.filterSingleLocalFilePath(path);
            if (newFilePath.startsWith("http://") || newFilePath.startsWith("https://")) {
                files.add(newFilePath);
                continue;
            }
            files.add(channel + newFilePath);
        }
        return Joiner.on((String)"&&").join((Iterable)files);
    }

    public static String filterSingleFilePath(String localFilePath) {
        if (StringUtil.isEmpty((String)localFilePath)) {
            return "";
        }
        if (localFilePath.contains("path=")) {
            return localFilePath.substring(localFilePath.indexOf("path=") + 5, localFilePath.length());
        }
        return localFilePath;
    }

    public static String filterFileDir(String filePath) {
        if (StringUtil.isEmpty((String)filePath)) {
            return "";
        }
        String fileName = Files.getNameWithoutExtension((String)filePath);
        String type = Files.getFileExtension((String)filePath);
        return filePath.replaceAll(fileName + "\\." + type, "");
    }

    public static String filterUrlFileDir(String filePath) {
        if (StringUtil.isEmpty((String)filePath)) {
            return "";
        }
        String localFilePath = FileUtils.filterSingleFilePath(filePath);
        String fileName = Files.getNameWithoutExtension((String)localFilePath);
        String type = Files.getFileExtension((String)localFilePath);
        return localFilePath.replaceAll(fileName + "\\." + type, "");
    }

    public static String filterSingleFileName(String localFilePath) {
        if (StringUtil.isEmpty((String)localFilePath)) {
            return "";
        }
        if (localFilePath.indexOf("path=") == -1) {
            return "";
        }
        String filePath = localFilePath.substring(localFilePath.indexOf("path=") + 5, localFilePath.length());
        if (filePath.contains("/")) {
            filePath = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        }
        return filePath;
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static synchronized String packTimestamp(String fileName) {
        if (StringUtil.isEmpty((String)fileName)) {
            return "";
        }
        if (fileName.contains(".")) {
            return Files.getNameWithoutExtension((String)fileName) + TI + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + Files.getFileExtension((String)fileName);
        }
        return fileName + TI + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
    }

    public static String appendFolderPath(String[] paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (sb.length() == 0) {
                sb.append(path);
                continue;
            }
            if (sb.toString().endsWith("/")) {
                sb.append(path).append("/");
                continue;
            }
            sb.append("/").append(path).append("/");
        }
        FileUtils.makeDir(sb.toString());
        return sb.toString();
    }

    public static void makeDir(String dir) {
        File fileDir = new File(dir);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
    }

    public static void downloadXlS(HttpServletResponse response, String rename, List<Map<String, Object>> list) throws IOException {
        FileUtils.downloadXLSPublic(response, rename, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadXLSPublic(HttpServletResponse response, String rename, List<Map<String, Object>> list, Map<String, String> headers) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            File dir = Files.createTempDir();
            File file = new File(dir.getPath() + "/" + System.currentTimeMillis() + ".xls");
            ExcelWriter writer = ExcelUtil.getWriter((File)file);
            if (headers != null) {
                writer.setHeaderAlias(headers);
            }
            writer.write(list);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(rename + ".xls", "utf-8"));
            writer.flush((OutputStream)out);
            writer.close();
            FileUtil.del((File)file);
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }

    public static void main(String[] args) {
    }
}

