package com.bcxin.risk.sys.resources;

import lombok.extern.slf4j.Slf4j;

import java.util.ResourceBundle;

/**
 * 配置文件常量
 * @author luopeng
 *
 */
@Slf4j
public class ConfigResources {
	
	public static String ENVI;
	public static String PROFILE_ENVI;
	public static String DEV_URL;


	public static String JDBC_URL;
	public static String JDBC_USERNAME;
	public static String JDBC_PASSWORD;


	public static String MAIL_HOST;
	public static String MAIL_USERNAME;
	public static String MAIL_PASSWORD;
	public static String MAIL_FROM;

	public static void init() {
		ResourceBundle configRb = ResourceBundle.getBundle("properties/config");
		ENVI = configRb.getString("envi");
		PROFILE_ENVI = configRb.getString("profile_envi");
		DEV_URL = configRb.getString("dev_url");

		MAIL_HOST = configRb.getString("mail_host");
		MAIL_USERNAME = configRb.getString("mail_from");
		MAIL_PASSWORD = configRb.getString("mail_password");
		MAIL_FROM = configRb.getString("mail_from");

		ResourceBundle jdbcRb = ResourceBundle.getBundle("properties/jdbc");
		JDBC_URL = jdbcRb.getString("jdbc.url");
		JDBC_USERNAME = jdbcRb.getString("jdbc.username");
		JDBC_PASSWORD = jdbcRb.getString("jdbc.password");
	}

}
