package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 用户操作菜单
 * @author luopeng
 */
@Slf4j
public class UserOpMenu {

	private static Map<String,String> MENU_MAP = Maps.newHashMap();


	private static void initMenu(){
		MENU_MAP.put("BACK_USER_MANAGE","后台用户列表");
		MENU_MAP.put("FRONT_USER_MANAGE","前台用户列表");
		MENU_MAP.put("SERVICE_ORG_MANAGE","服务机构列表");
		MENU_MAP.put("SERVICE_ORG_APPROVAL","服务机构列表审核");
		MENU_MAP.put("GOV_ORG_APPROVAL","政府单位账号审核");
		MENU_MAP.put("EXPERT_USER_MANAGE","专家用户列表");
		MENU_MAP.put("EXPERT_USER_APPROVAL","专家用户审核");
		MENU_MAP.put("FULL_ORDER_MANAGE","订单列表");
		MENU_MAP.put("BUSINESS_ORDER_MANAGE","许可列表");
		MENU_MAP.put("BACK_ORDER_MANAGE","备案列表");
		MENU_MAP.put("NEWS_PUBLISH","发布公告");
		MENU_MAP.put("NEWS_MANAGE","新闻列表");
		MENU_MAP.put("ROLE_MANAGE","角色管理");
		MENU_MAP.put("USER_MANAGE","人员管理");
		MENU_MAP.put("SERVICE_REGION_MANAGE","机构服务区域管理");
		MENU_MAP.put("COMPOSE_TEMPLATE_MANAGE","撰写模版管理");
		MENU_MAP.put("COMPOSE_RISK_MANAGE","风险管理信息库");
		MENU_MAP.put("COMPOSE_CASE_MANAGE","事故案例信息库");
		MENU_MAP.put("COMPOSE_VENUE_MANAGE","场地信息库");
		MENU_MAP.put("COMPOSE_WEATHER_MANAGE","自然气候信息库");
		MENU_MAP.put("COMPOSE_RULE_MANAGE","法规信息库");
		MENU_MAP.put("COMPOSE_STANDARD_MANAGE","专业规范信息库");
		MENU_MAP.put("CONVENIENCE_MANAGE","便民服务内容编辑");
		MENU_MAP.put("SYS_TIPS_MANAGE","升级提示");
		MENU_MAP.put("SYS_SP_TIPS_MANAGE","内网升级提示");
		MENU_MAP.put("ACTIVITY_HISTORY_MANAGE","数据录入");
		MENU_MAP.put("KNOWLEDGE_BASE_MANAGE","知识文库管理");
		MENU_MAP.put("NOTIFY_MANAGE","通知管理");
	}

	/**
	 * 获得菜单
	 * @param key
	 * @return
	 */
	public static String get(String key){
		if (MapUtil.isEmpty(MENU_MAP)) {
			initMenu();
		}
		return MENU_MAP.get(key);
	}

}
