package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrSpliter;
import com.bcxin.risk.report.material.dao.MaterialFormOptionDao;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 材料上传字典工具类
 * @author luopeng
 */
@Service
@Transactional
public class SysMaterialOptionUtil {

	@Resource
	private MaterialFormOptionDao materialFormOptionDao;

	private Map<String,Collection<MaterialFormOption>> CACHE_KEY_MATERIAL_OPTION = Maps.newHashMap();

	public String getOptionLabel(String value, String type, String defaultValue){
		if (StringUtils.isNotBlank(type) && StringUtils.isNotBlank(value)){
			/* 从数据库查数据 */
			if (type.startsWith("diy") && type.contains("|")) {
				Collection<MaterialFormOption> valueList = getOptionList(type);
				for (MaterialFormOption option : valueList) {
					if (value.equals(option.getValue())) {
						return option.getName();
					}
				}
			} else {
				Collection<MaterialFormOption> list = optionMap().get(type.toUpperCase());
				for (MaterialFormOption option : list) {
					if (value.equals(option.getValue())) {
						return option.getName();
					}
				}
			}
		}
		return defaultValue;
	}



	public Collection<MaterialFormOption> getOptionList(String type){
		/* 从数据库查数据 */
		if (type.startsWith("diy") && type.contains("|")) {
			List<String> list = StrSpliter.split(type,"|",true,true);
			return materialFormOptionDao.selectDIYOptionList(list.get(1),list.get(2),list.get(3),list.get(4));
		}
		return optionMap().get(type.toUpperCase()); //因为数据字典类型均为大写
	}

	/**
	 * 获取dictList
	 * @return
	 */
	public Map<String,Collection<MaterialFormOption>> optionMap(){
		if (MapUtil.isNotEmpty(CACHE_KEY_MATERIAL_OPTION)) {
			return CACHE_KEY_MATERIAL_OPTION;
		}
		List<MaterialFormOption> dictList = materialFormOptionDao.selectOptionList();
		Multimap<String, MaterialFormOption> map = ArrayListMultimap.create();
		for(MaterialFormOption option: dictList){
			map.put(option.getType().toUpperCase(),option);
		}
		CACHE_KEY_MATERIAL_OPTION = map.asMap();
		return CACHE_KEY_MATERIAL_OPTION;
	}

}
