package com.bcxin.risk.expert;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.expert.domain.ExpertCheckInfo;
import com.bcxin.risk.user.domain.ExpertUser;

import java.util.Objects;

public class ExpertUtil {
    /**
     * 初级
     */
    private final static String LEVEL_1 = "1";
    /**
     * 中级
     */
    private final static String LEVEL_2 = "2";
    /**
     * 高级
     */
    private final static String LEVEL_3 = "3";

    /**
     * 转换专家等级
     * @param level
     * @return
     */
    public static String transferExpertLevel(String level) {
        if (Objects.equals(LEVEL_1, level)) {
            return "初级";
        } else if (Objects.equals(LEVEL_2, level)) {
            return "中级";
        } else if (Objects.equals(LEVEL_3, level)) {
            return "高级";
        }
        return "";
    }


    /**
     * 获取专家任务类型
     * @param userType
     * @return
     */
    public static String getExpertTaskType(String userType){
        if(ObjectUtil.equal(userType,DictConst.USERTYPE_DSFFWJGYH_ZXZJ)){
            return DictConst.EXPERTTASKTYPE_ZX;
        }
        return DictConst.EXPERTTASKTYPE_TK;
    }

    /**
     * 转换专家对象
     * @param expertUser
     * @param info
     * @return
     */
    public static ExpertUser transferExpertUser(ExpertUser expertUser, ExpertCheckInfo info){
        expertUser.setRealName(info.getRealName());
        expertUser.setPhone(info.getPhone());
        expertUser.setSex(info.getSex());
        expertUser.setEmail(info.getEmail());
        expertUser.setLevel(info.getLevel());
        expertUser.setTaskQuote(info.getTaskQuote());
        //政治面貌
        expertUser.setPolitical(info.getPolitical());
        expertUser.setEducation(info.getEducation());
        expertUser.setEducationNo(info.getEducationNo());
        expertUser.setWorkTitle(info.getWorkTitle());
        expertUser.setAptitude_cert(info.getAptitude_cert());
        expertUser.setWorkExperience(info.getWorkExperience());
        expertUser.setExpertCategory(transferExpertLevel(info.getLevel()));
        expertUser.setIndustryCategory(info.getIndustryCategory());
        expertUser.setCheckStatus(info.getCheckStatus());
        expertUser.setCardNo(info.getCardNo());
        expertUser.setBirthday(info.getBirthday());
        expertUser.setNation(info.getNation());
        expertUser.setMarital(info.getMarital());
        expertUser.setNativeInfo(info.getNativeInfo());
        expertUser.setNativeInfoCode(info.getNativeInfoCode());
        expertUser.setCompanyOrDept(info.getCompanyOrDept());
        expertUser.setPosition(info.getPosition());
        expertUser.setJobLiveAddr(info.getJobLiveAddr());
        expertUser.setJobLiveAddrCode(info.getJobLiveAddrCode());
        expertUser.setProfessional(info.getProfessional());
        expertUser.setEducationExperience(info.getEducationExperience());
        expertUser.setLearningExperience(info.getLearningExperience());
        expertUser.setProjectExperience(info.getProjectExperience());
        expertUser.setLearningPaper(info.getLearningPaper());
        expertUser.setSuccessExperience(info.getSuccessExperience());
        expertUser.setPersonAchievement(info.getPersonAchievement());
        expertUser.setExpertSource(info.getExpertSource());
        expertUser.setSignature(info.getSignature());
        return expertUser;
    }
}
