package com.bcxin.risk.dynamic;

import com.alibaba.fastjson.JSON;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityCooperDao;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.compose.draft.ComposeFile;
import com.bcxin.risk.compose.draft.ComposeFileDao;
import com.bcxin.risk.compose.draft.ComposeTask;
import com.bcxin.risk.compose.draft.ComposeTaskDao;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.dynamic.dto.*;
import com.bcxin.risk.enums.DynamicPermissionEnum;
import com.bcxin.risk.enums.DynamicTypeEnum;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.OrderFormDao;
import com.bcxin.risk.order.Transaction;
import com.bcxin.risk.order.TransactionDao;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.report.material.dao.ReportDao;
import com.bcxin.risk.survey.SurveyExpertDao;
import com.bcxin.risk.survey.domain.Task;
import com.bcxin.risk.surveytk.TaskDao;
import com.bcxin.risk.user.dao.UserDao;
import com.bcxin.risk.user.domain.User;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author hzp
 * 动态看板工具类
 * 采用异步调用方式
 */
@Service
@Transactional
@Slf4j
public class DynamicUtil {

    @Autowired
    DynamicPanelDao dynamicPanelDao;
    @Autowired
    ActivityDao activityDao;
    @Autowired
    DynamicPanelTemplateDao dynamicPanelTemplateDao;
    @Autowired
    ReportDao reportDao;
    @Autowired
    TransactionDao transactionDao;
    @Autowired
    ActivityCooperDao activityCooperDao;
    @Autowired
    OrderFormDao orderFormDao;
    @Autowired
    ComposeTaskDao composeTaskDao;
    @Autowired
    ComposeFileDao composeFileDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    SurveyExpertDao surveyExpertDao;
    @Autowired
    UserDao userDao;


    /**
     * 检查动态信息是否已经存在
     * @param templateId
     * @param userId
     * @param activityId
     * @return
     */
    public boolean checkDynamic(Long templateId,Long userId,Long activityId){
        return dynamicPanelDao.checkDynamic(templateId,userId,activityId);
    }

    /****************************************承办方*******************************************/
    /**
     * 承办方
     * @param operateUser
     * @param activity
     * @param templateId
     * @param typeEnum
     */
    @Async
    public void saveContractData(User operateUser,Activity activity,Long templateId,DynamicTypeEnum typeEnum){
        OrderForm orderForm=orderFormDao.findOrderFormByAcivity(activity);
        saveData(operateUser,orderForm,templateId,typeEnum,DynamicPermissionEnum.DYNAMIC_CONTRACTOR);
    }

    /**
     * 承办方
     * @param operateUser
     * @param orderForm
     * @param templateId
     * @param typeEnum
     */
    @Async
    public void saveContractData(User operateUser,OrderForm orderForm,Long templateId,DynamicTypeEnum typeEnum){
        saveData(operateUser, orderForm, templateId, typeEnum, DynamicPermissionEnum.DYNAMIC_CONTRACTOR);
    }

    /****************************************风评机构*******************************************/

    /**
     * 风评
     * @param operateUser
     * @param activity
     * @param templateId
     * @param typeEnum
     */
    @Async
    public void saveFPData(User operateUser,Activity activity,Long templateId,DynamicTypeEnum typeEnum){
        OrderForm orderForm=orderFormDao.findOrderFormByAcivity(activity);
        // 特殊处理
        if(templateId.toString().equals("200002")){
            typeEnum=DynamicTypeEnum.DYNAMIC_ORDER;
        }
        saveFPData(operateUser,orderForm,templateId,typeEnum);
    }

    /**
     * 风评
     * @param operateUser
     * @param orderId
     * @param templateId
     * @param typeEnum
     */
    @Async
    public void saveFPData(User operateUser,Long orderId,Long templateId,DynamicTypeEnum typeEnum){
        OrderForm orderForm = orderFormDao.findOrderFormByOid(orderId);
        saveFPData(operateUser,orderForm,templateId,typeEnum);
    }

    /**
     * 风评
     * @param operateUser
     * @param orderForm
     * @param templateId
     * @param typeEnum
     */
    @Async
    public void saveFPData(User operateUser,OrderForm orderForm,Long templateId,DynamicTypeEnum typeEnum){
        saveData(operateUser,orderForm,templateId,typeEnum,DynamicPermissionEnum.DYNAMIC_FENGPING);
    }

    /**
     * 保存风评数据
     * @param operateUser 当前用户
     * @param templateId
     * @param reportId 报告id
     * @param reportFile 报告url
     */
    @Async
    public void saveFPReportData(User operateUser,Long templateId,Long reportId,String reportFile,String reportType,String reSubmit){
        Report report=reportDao.selectById(reportId);
        if(report==null){
            return;
        }
        Activity activity=report.getActivity();
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Org org = getPGOrg(orgList);
        Long contractOrgId=activity.getOrg().getOid();

        DynamicPanel panel=new DynamicPanel();

        // 这里做特殊处理
        if(templateId.equals(DynamicTemplateConst.DYNAMIC_TEMP_FENGPING_200003)){
            panel.setOrgId(org.getOid());
        }else if(templateId.equals(DynamicTemplateConst.DYNAMIC_TEMP_FENGPING_200004)){
            panel.setContractOrgId(contractOrgId);
        }else{
            panel.setOrgId(org.getOid());
        }

        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        // 特殊处理
        if(templateId.toString().equals("200003")){
            panel.setDynamicType(DynamicTypeEnum.DYNAMIC_ORDER.getKey());
        }else {
            panel.setDynamicType(DynamicTypeEnum.DYNAMIC_FENGPING.getKey());
        }
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_FENGPING.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());

        if(StringUtil.isEmpty(reportType)) {
            String[] tmp = reportFile.split("\\|\\|");
            if (tmp != null && tmp.length > 1) {
                reportFile = ConfigUtil.getValue("web_url")+tmp[1];
            }
        }

        DynamicFengPingPanel fpPanel=new DynamicFengPingPanel(operateUser,org,activity,reportFile,reportType);
        // 重新提交标识
        fpPanel.setReSubmit(reSubmit);
        // 空值也进行序列化
        panel.setTemplateData(JSON.toJSONString(fpPanel));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    @Async
    public void saveData(User operateUser,OrderForm orderForm,Long templateId,DynamicTypeEnum typeEnum,DynamicPermissionEnum permissionEnum){
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(orderForm.getActivity());
        Activity activity=orderForm.getActivity();
        Long contractOrgId=activity.getOrg().getOid();
        Long orgId=getPingGuOrg(orgList);

        DynamicPanel panel = new DynamicPanel();
        // 设置数据权限
        if(permissionEnum==DynamicPermissionEnum.DYNAMIC_FENGPING){
            panel.setOrgId(orgId);
        }else if(permissionEnum==DynamicPermissionEnum.DYNAMIC_CONTRACTOR){
            panel.setContractOrgId(contractOrgId);
        }else{
            panel.setOrgId(orgId);
            panel.setContractOrgId(contractOrgId);
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(typeEnum.getKey());
        if (operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(transferData(typeEnum,operateUser,orderForm,orgList)));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    /****************************************START 撰写*******************************************/
    /**
     * 保存撰写
     * @param operateUser
     * @param templateId
     * @param report
     */
    @Async
    public void saveZXData(User operateUser,Long templateId,Report report,ComposeTask composeTask){
        Activity activity=report.getActivity();
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        ComposeFile composeFile=null;
        if(composeTask!=null){
            composeFile=composeFileDao.findByReportAndTask(report.getOid(),composeTask.getOid());
        }
        Long orgId=getPingGuOrg(orgList);

        DynamicPanel panel=new DynamicPanel();
        panel.setOrgId(orgId);
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_ZHUANXIE.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_FENGPING.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(transferZXData(operateUser,report,composeFile,orgList)));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    /**
     * 数据转换-撰写动态
     * @param operateUser
     * @param report
     * @param composeFile
     * @param orgList
     * @return
     */
    public Object transferZXData(User operateUser,Report report,ComposeFile composeFile,
                                 List<ActivityCooperDTO> orgList){
        Object object=null;
        Org pgOrg=getPGOrg(orgList);
        List<ComposeTask> composeTaskList=composeTaskDao.findByActivity(report.getActivity());
        object=new DynamicZhuanXiePanel(operateUser,report,composeFile,pgOrg,composeTaskList);
        return object;
    }

    /****************************************END 撰写*******************************************/


    /****************************************START 踏勘*******************************************/
    @Async
    public void saveTKData(User operateUser,Long templateId,Long taskId,User tkUser){
        saveTKData(operateUser,templateId,taskId,tkUser,DynamicPermissionEnum.DYNAMIC_ALL);
    }

    @Async
    public void saveTKData(User operateUser,Long templateId,Long taskId,User tkUser,DynamicPermissionEnum permissionEnum){
        Task task=taskDao.selectById(taskId);
        saveTKData(operateUser,templateId,task,tkUser,permissionEnum);
    }

    @Async
    public void saveSuggestTKData(User operateUser,Activity activity,Long templateId,String suggest,
                                  String photos,String step,DynamicPermissionEnum permissionEnum){
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId=getPingGuOrg(orgList);
        Long contractId=activity.getOrg().getOid();

        DynamicPanel panel=new DynamicPanel();

        if(permissionEnum==DynamicPermissionEnum.DYNAMIC_FENGPING){
            panel.setOrgId(orgId);
        }else if(permissionEnum==DynamicPermissionEnum.DYNAMIC_CONTRACTOR){
            panel.setContractOrgId(contractId);
        }else {
            panel.setContractOrgId(contractId);
            panel.setOrgId(orgId);
        }

        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(new DynamicSurveyPanel(operateUser,activity,suggest,photos,step)));
        dynamicPanelDao.saveOrUpdate(panel);

    }

    @Async
    public void saveTKData(User operateUser,Long templateId,Task task,User tkUser,DynamicPermissionEnum permissionEnum){
        Activity activity=task.getActivity();
        String tkzjUserList=surveyExpertDao.findSurveyExperts(task.getOid());
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId=getPingGuOrg(orgList);
        Long contractId=activity.getOrg().getOid();

        DynamicPanel panel=new DynamicPanel();

        if(permissionEnum==null){
            permissionEnum=DynamicPermissionEnum.DYNAMIC_ALL;
        }
        if(permissionEnum==DynamicPermissionEnum.DYNAMIC_CONTRACTOR){
            panel.setContractOrgId(contractId);
        }else if(permissionEnum==DynamicPermissionEnum.DYNAMIC_FENGPING){
            panel.setOrgId(orgId);
        }else{
            panel.setContractOrgId(contractId);
            panel.setOrgId(orgId);
        }

        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(new DynamicSurveyPanel(operateUser,task,tkUser,tkzjUserList)));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    /**
     * 保存踏勘人员申请的专家
     * @param operateUser
     * @param templateId
     * @param taskId
     * @param expertId
     */
    @Async
    public void saveTKExpertData(User operateUser,Long templateId,Long taskId,String expertId){
        Task task=taskDao.selectById(taskId);
        DynamicPermissionEnum permissionEnum=DynamicPermissionEnum.DYNAMIC_ALL;
        Activity activity=task.getActivity();
        String tkzjUserList="";
        User user=userDao.selectById(Long.parseLong(expertId.split("#")[0]));
        if(user!=null) {
            tkzjUserList = user.getRealName() + " " + user.getPhone();
        }
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId=getPingGuOrg(orgList);
        Long contractId=activity.getOrg().getOid();

        DynamicPanel panel=new DynamicPanel();
        panel.setContractOrgId(contractId);
        panel.setOrgId(orgId);
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(new DynamicSurveyPanel(operateUser,task,null,tkzjUserList)));
        dynamicPanelDao.saveOrUpdate(panel);
    }
    /****************************************END 踏勘*******************************************/



    /****************************************START 活动动态*******************************************/

    /**
     * 保存活动动态看板
     * @param userId
     * @param activityId
     * @param activityName
     */
    @Async
    public void saveDynamicActPanel(Long userId,Long activityId,String activityName,Long templateId){
        User user=userDao.findUserByOid(userId);
        if(user==null){
            return;
        }
        DynamicActPanel actPanel=new DynamicActPanel(user,activityId+"",activityName);
        DynamicPanel panel=new DynamicPanel();
        if(user!=null) {
            panel.setOperateId(user.getOid());
            panel.setOperateType(user.getUserType());
            panel.setOperateName(user.getRealName());
            panel.setContractOrgId(user.getOrg().getOid());
        }
        panel.setActivityId(activityId);
        panel.setActivityName(activityName);
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_ACTIVITY.getKey());
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_CONTRACTOR.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(actPanel));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    /****************************************END 活动动态*******************************************/



    /****************************************START 审批动态*******************************************/

    /**
     * 600001L  主站-提交初审
     * 600004L  主站-重新提交初审
     * 600005L  主站-提交审批、报告触发
     * 600011L  主站-重新提交审批
     * @param activityId
     * @param templateId
     */
    @Async
    public void saveDynamicApprovePanel(Long activityId,Long templateId){
        Activity activity=activityDao.findActivityByOid(activityId);
        User user=activity.getUser();
        if(user==null){
            return;
        }
        saveDynamicApprovePanel(activity,templateId,null,null,null);
    }

    /**
     * 保存审批转交动态
     * @param activityId
     * @param transferArea
     * @param transferContent
     */
    @Async
    public void saveTransferPanel(Long activityId,String transferArea,String transferContent){
        Activity activity=activityDao.findActivityByOid(activityId);
        User user=activity.getUser();
        if(user==null){
            return;
        }
        Long templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600012;
        saveDynamicApprovePanel(activity,templateId,null,transferArea,transferContent);
    }


    /**
     * 保存审批动态
     * @param sbApproveStatus
     * @param content
     */
    public void saveApprovePanel(Activity activity,String sbApproveStatus,String content){
        User user=activity.getUser();
        if(user==null){
            return;
        }
        Long templateId=null;
        if(Objects.equals(sbApproveStatus,DictConst.PRIMARYSTATUS_CSXG)){
            // 初审退回
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600003;
        }else if(Objects.equals(sbApproveStatus,DictConst.PRIMARYSTATUS_CSTG)){
            // 初审通过
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600002;
        }else if(Objects.equals(sbApproveStatus,DictConst.SLSTATUS_BSL)){
            // 不予受理
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600007;
        }else if(Objects.equals(sbApproveStatus,DictConst.SLSTATUS_SL)){
            // 受理通过
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600006;
        }else if(Objects.equals(sbApproveStatus,DictConst.APPROVALSTATUS_SHTG)){
            // 审批许可
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600009;
        }else if(Objects.equals(sbApproveStatus,DictConst.APPROVALSTATUS_SHBTG)){
            // 审批不许可
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600010;
        }else if(Objects.equals(sbApproveStatus,DictConst.APPROVALSTATUS_SHDH)){
            // 审批打回
            templateId=DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600008;
        }
        if(templateId==null){
            return;
        }
        saveDynamicApprovePanel(activity,templateId,content,null,null);
    }


    /**
     * 统一保存方法
     * @param activity
     * @param templateId
     * @param approveContent
     * @param transferArea
     * @param transferContent
     */
    public void saveDynamicApprovePanel(Activity activity,Long templateId,String approveContent,String transferArea,String transferContent){
        User user=activity.getUser();
        if(user==null){
            return;
        }
        DynamicApprovePanel approvePanel=new DynamicApprovePanel();
        approvePanel.setActivityId(activity.getOid()+"");
        approvePanel.setActivityName(activity.getName());
        approvePanel.setUserName(user.getUserName());
        approvePanel.setOperateId(user.getOid()+"");
        approvePanel.setOperateName(user.getRealName());
        approvePanel.setTransferArea(transferArea);
        approvePanel.setTransferContent(transferContent);
        approvePanel.setApproveContent(approveContent);

        DynamicPanel panel=new DynamicPanel();
        if(user!=null) {
            panel.setOperateId(user.getOid());
            panel.setOperateType(user.getUserType());
            panel.setOperateName(user.getRealName());
            panel.setContractOrgId(user.getOrg().getOid());
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_APPROVE.getKey());
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_CONTRACTOR.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(approvePanel));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    /****************************************END 审批动态*******************************************/


    /****************************************START 修改日志*******************************************/


    /**
     * 更新动态看板显示状态
     * @param activityId
     * @param showStatus
     */
    public void updateDynamicLogShowStatus(Long activityId,String showStatus){
        dynamicPanelDao.updateDynamicShowStatus(activityId,showStatus);
    }

    /**
     * 保存活动修改日志
     * @param activityId
     */
    @Async
    public void saveDynamicActUpdateLog(Long activityId) {
        Activity activity = activityDao.findActivityByOid(activityId);
        saveDynamicActUpdateLogFP(activity);
        saveDynamicActUpdateLogContractor(activity);
    }


    /**
     * 保存风评修改日志
     * @param activity
     */
    public void saveDynamicActUpdateLogFP(Activity activity){
        List<ActivityCooperDTO> orgList = activityCooperDao.findActivityCooperDtoByActivty(activity);
        Org org = getPGOrg(orgList);
        if (org == null) {
            return;
        }
        String dynamicOid="";
//        String dynamicOid=dynamicPanelDao.checkPGDynamic(DynamicTemplateConst.DYNAMIC_TEMP_ORDER_100006,org.getOid(),activity.getOid());
        if(StringUtil.isEmpty(dynamicOid)) {
            DynamicPanel dynamicPanel = new DynamicPanel();
            //风评机构
            dynamicPanel.setOrgId(org.getOid());
            dynamicPanel.setUpdateOn(new Date());
            dynamicPanel.setCreateOn(new Date());
            dynamicPanel.setActivityId(activity.getOid());
            dynamicPanel.setActivityName(activity.getName());
            dynamicPanel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(DynamicTemplateConst.DYNAMIC_TEMP_ORDER_100006));
            dynamicPanel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_FENGPING.getKey());
            dynamicPanel.setDynamicType(DynamicTypeEnum.DYNAMIC_ORDER.getKey());
            DynamicFengPingPanel fpPanel = new DynamicFengPingPanel();
            fpPanel.setContractName(activity.getSponsor());
            fpPanel.setActivityId(activity.getOid() + "");
            fpPanel.setActivityName(activity.getName());
            dynamicPanel.setTemplateData(JSON.toJSONString(fpPanel));
            // 设置不显示
            dynamicPanel.setIsShow(DictConst.Y);
            dynamicPanelDao.saveOrUpdate(dynamicPanel);
        }else {
            // 重新更新时间
            DynamicPanel panel=dynamicPanelDao.selectById(Long.parseLong(dynamicOid));
            dynamicPanelDao.saveOrUpdate(panel);
        }
    }


    /**
     * 保存承办方修改日志
     * @param activity
     */
    public void saveDynamicActUpdateLogContractor(Activity activity){
        Org org=activity.getOrg();
        String dynamicOid="";
//        String dynamicOid=dynamicPanelDao.checkPGDynamic(DynamicTemplateConst.DYNAMIC_TEMP_ACTIVITY_500003,org.getOid(),activity.getOid());
        if(StringUtil.isEmpty(dynamicOid)) {
            DynamicPanel dynamicPanel = new DynamicPanel();
            //风评机构
            dynamicPanel.setContractOrgId(org.getOid());
            dynamicPanel.setUpdateOn(new Date());
            dynamicPanel.setCreateOn(new Date());
            dynamicPanel.setActivityId(activity.getOid());
            dynamicPanel.setActivityName(activity.getName());
            dynamicPanel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(DynamicTemplateConst.DYNAMIC_TEMP_ACTIVITY_500003));
            dynamicPanel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_CONTRACTOR.getKey());
            dynamicPanel.setDynamicType(DynamicTypeEnum.DYNAMIC_ACTIVITY.getKey());
            DynamicFengPingPanel fpPanel = new DynamicFengPingPanel();
            fpPanel.setContractName(activity.getSponsor());
            fpPanel.setActivityId(activity.getOid() + "");
            fpPanel.setActivityName(activity.getName());
            fpPanel.setOperateId(activity.getUser().getOid().toString());
            fpPanel.setOperateName(activity.getUser().getUserName());
            dynamicPanel.setTemplateData(JSON.toJSONString(fpPanel));
            // 设置不显示
            dynamicPanel.setIsShow(DictConst.Y);
            dynamicPanelDao.saveOrUpdate(dynamicPanel);
        }else {
            // 重新更新时间
            DynamicPanel panel=dynamicPanelDao.selectById(Long.parseLong(dynamicOid));
            panel.setCreateOn(new Date());
            panel.setUpdateOn(new Date());
            dynamicPanelDao.saveOrUpdate(panel);
        }
    }

    /****************************************END 修改日志*******************************************/


    /**
     * 数据转换
     * @param typeEnum
     * @param operateUser
     * @param orderForm
     * @return
     */
    public Object transferData(DynamicTypeEnum typeEnum, User operateUser,OrderForm orderForm,
                               List<ActivityCooperDTO> orgList){
        Object object=null;
        Report report=reportDao.findReportByActivity(orderForm.getActivity());
        Transaction transaction=transactionDao.findTransactionByOrder(orderForm);
        Org pgOrg=getPGOrg(orgList);

        switch (typeEnum){
            case DYNAMIC_ORDER:
                object=new DynamicOrderPanel(operateUser,orderForm,transaction,report,orgList);
                break;
            case DYNAMIC_FENGPING:
                object=new DynamicFengPingPanel(operateUser,orderForm,report,pgOrg);
                break;
            case DYNAMIC_ZHUANXIE:
                break;
            case DYNAMIC_KANCHA:
                break;
            default:
        }
        return object;
    }

    /**
     * 获取评估机构
     * @param orgList
     * @return
     */
    public Long getPingGuOrg(List<ActivityCooperDTO> orgList){
        if(orgList!=null){
            for(ActivityCooperDTO dto : orgList){
                if(Objects.equals(dto.getServiceOrgType(),DictConst.SERVICEORGTYPE_FXPGJG)){
                    return Long.parseLong(dto.getOid());
                }
            }
        }
        return null;
    }

    /**
     * 获取风评机构
     * @param orgList
     * @return
     */
    public Org getPGOrg(List<ActivityCooperDTO> orgList){
        Org org=new Org();
        if(orgList!=null){
            for(ActivityCooperDTO dto : orgList){
                if(Objects.equals(dto.getServiceOrgType(),DictConst.SERVICEORGTYPE_FXPGJG)){
                    org.setOid(Long.parseLong(dto.getOid()));
                    org.setName(dto.getName());
                    return org;
                }
            }
        }
        return null;
    }

    /**
     * 根据模板id获取对应的类型
     * @param templateId
     * @return
     */
    private DynamicTypeEnum getDynamicType(Long templateId){
        String key=templateId.toString().substring(0,3);
        for(DynamicTypeEnum typeEnum : DynamicTypeEnum.values()){
            if(typeEnum.getKey().equals(key)){
                return typeEnum;
            }
        }
        return null;
    }
}
