package com.bcxin.risk.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * <b>字典常量字段库 </b>
 *
 * @author xiangyaoqi
 * @date 2017年05月02日
 * @注意事项 </b>
 * <b>
 */
public final class DictConst {

	private DictConst() {
	} //空的构造函数，避免实例化该类

	/**
	 * 基础的，是和否
	 */
	public final static String Y = "1";
	public final static String N = "0";


	/**
	 * 码表基本信息
	 */

	/* 活动状态 */
	public final static String ACTIVITYSTATUS_SQZ = "10";    //活动状态_申请中
	public final static String ACTIVITYSTATUS_SPDH = "25";    //活动状态_审批打回
	//public final static String ACTIVITYSTATUS_SPZ = "20";    //活动状态_审批中
	//public final static String ACTIVITYSTATUS_BXK = "30";    //活动状态_不许可
	//public final static String ACTIVITYSTATUS_CBJB = "40";    //活动状态_筹备举办（通过当前时间和活动时间判断，未到活动时间为筹备中，否则为举办中）
	public final static String ACTIVITYSTATUS_HDJS = "50";    //活动状态_结束


	/*初审状态*/
	public final static String PRIMARYSTATUS_CSZ = "10";    //初审中（提交初审）
	public final static String PRIMARYSTATUS_CSXG = "20";   //初审不通过（初审退回）
	public final static String PRIMARYSTATUS_CSTG = "30";    //初审通过（初审通过）


	/*受理状态*/
	public final static String SLSTATUS_SLZ = "SL10"; //受理中
	public final static String SLSTATUS_BSL = "SL20";//不予受理
	public final static String SLSTATUS_SL = "SL30";//受理通过--》审批中


	/* 活动材料类型 ACTIVITYMATERIALTYPE */
	public final static String ACTIVITYMATERIALTYPE_PGBG = "1";    //材料类型_评估报告
	public final static String ACTIVITYMATERIALTYPE_PGBG_GEN = "01";  //材料类型_评估报告_系统自动生成报告
	public final static String ACTIVITYMATERIALTYPE_DZBD = "2";    //材料类型_电子保单
	public final static String ACTIVITYMATERIALTYPE_JLBG_KS = "3";   //材料类型_监理报告（活动开始前）
	public final static String ACTIVITYMATERIALTYPE_DYJDTKBG = "4";    //材料类型_第一阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_DEJDTKBG = "5";    //材料类型_第二阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_DSJDTKBG = "6";    //材料类型_第三阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_PGCL = "7";    //材料类型_评估材料
	public final static String ACTIVITYMATERIALTYPE_PGCL_BC = "07";    //材料类型_评估材料_补充材料
	public final static String ACTIVITYMATERIALTYPE_BPCL = "8";    //报批材料
	public final static String ACTIVITYMATERIALTYPE_JLBG_JS = "10";  //材料类型_监理报告（活动结束后）


	/* 报告材料类型 REPORTMATERIALTYPE */
	public final static String REPORTMATERIALTYPE_CG = "1";    //材料类型_初稿
	public final static String REPORTMATERIALTYPE_YS = "2";    //材料类型_一审
	public final static String REPORTMATERIALTYPE_ZJ = "3";   //材料类型_专家
	public final static String REPORTMATERIALTYPE_FH = "4";  //材料类型_复核
	public final static String REPORTMATERIALTYPE_FINAL = "10";    //材料类型_最终版


	/* 活动来源 */
	public final static String ACTIVITYSOURCE_ZXSB = "1";  //在线申报
	public final static String ACTIVITYSOURCE_XTLR = "2";  //系统录入
	public final static String ACTIVITYSOURCE_ZXCJ = "3";  //在线创建

	/* 交易产生对象 TRANSACTIONOBJECT */
	public final static String TRANSACTIONOBJECT_FXBG = "1";    //交易产生对象_风险报告
	public final static String TRANSACTIONOBJECT_BX = "2";    //交易产生对象_保险

	/* 支付方式  PAYMENTMODE */
	public final static String PAYMENTMODE_XSZF = "1";    //支付方式_线上支付
	public final static String PAYMENTMODE_XXZF = "2";    //支付方式_线下支付


	/* 线上支付类型 PAYMENTTYP */
	public final static String PAYMENTTYPE_ZFB = "1";    //线上支付类型_支付宝
	public final static String PAYMENTTYPE_WS = "2";    //线上支付类型_微信
	public final static String PAYMENTTYPE_YL = "3";    //线上支付类型_银联
	public final static String PAYMENTTYPE_UMPAY = "4";    //线上支付类型_联动优势
	public final static String PAYMENTTYPE_BOOFOO = "5";    //线上支付类型_宝付


	/* 机构类型 ORGTYPE */
	public final static String ORGTYPE_CBDW = "1";    //机构类型_承办单位
	public final static String ORGTYPE_ZJJG = "2";    //机构类型_专家机构
	public final static String ORGTYPE_GAJG = "3";    //机构类型_公安机构
	public final static String ORGTYPE_GLJG = "4";    //机构类型_管理机构
	public final static String ORGTYPE_DSFFWJG = "5";    //机构类型_第三方服务机构


	/* 系统日志类型 LOGTYPE */
	public final static String LOGTYPE_XTYC = "1";    //系统日志类型_系统异常
	public final static String LOGTYPE_DSRW = "2";    //系统日志类型_定时任务


	/* 新闻类型 NEWSTYPE */
	public final static String NEWSTYPE_GGTZ = "0";            //新闻类型_公告通知
	public final static String NEWSTYPE_HYZX = "1";            //新闻类型_行业资讯
	public final static String NEWSTYPE_HDXX = "2";            //新闻类型_活动信息
	public final static String NEWSTYPE_ZCFL = "3";            //新闻类型_政策法律


	/* 用户类型 USERTYPE */
	public final static String USERTYPE_CJGLY = "0";    //用户类型_超级管理员
	public final static String USERTYPE_CBDWYH = "1";    //用户类型_承办单位用户
	public final static String USERTYPE_CBDWYH_Z = "101";    //用户类型_承办单位用户_子账户
	public final static String USERTYPE_ZJJGYH = "2";    //用户类型_专家机构用户
	public final static String USERTYPE_GAJGYH = "3";    //用户类型_公安机构用户
	public final static String USERTYPE_GLJGYH = "4";    //用户类型_管理机构用户
	public final static String USERTYPE_GLJGYH_CW = "6";    //用户类型_管理机构用户_出纳
	public final static String USERTYPE_DSFFWJGYH = "5";    //用户类型_第三方服务机构用户
	public final static String USERTYPE_DSFFWJGYH_JS = "7";    //用户类型_风险评估机构用户_结算人员
	public final static String USERTYPE_DSFFWJGYH_ZG = "8";    //用户类型_风险评估机构用户_主管
	public final static String USERTYPE_DSFFWJGYH_ZXZY = "9";    //用户类型_自营服务机构用户_撰写单位_撰写专员 （初稿人员）
	public final static String USERTYPE_DSFFWJGYH_YSZY = "10";    //用户类型_自营服务机构用户_撰写单位_一审专员 （审核人员）
	public final static String USERTYPE_DSFFWJGYH_FHRY = "11";    //用户类型_自营服务机构用户_撰写单位_复核人员  （评估组长）
	public final static String USERTYPE_DSFFWJGYH_XZRY = "13";    //用户类型_自营服务机构用户_撰写单位_行政人员
	public final static String USERTYPE_DSFFWJGYH_TKQT = "14";    //用户类型_自营服务机构用户_勘查相关人员
	public final static String USERTYPE_ZJGLY = "15";    //用户类型_专家管理员
	public final static String USERTYPE_DSFFWJGYH_ZXZJ = "16"; //用户类型_第三方服务机构用户_撰写专家
	public final static String USERTYPE_DSFFWJGYH_TKZJ = "17"; //用户类型_第三方服务机构用户_勘查专家
	public final static String USERTYPE_DSFFWJGYH_TKXMJL = "18";    //用户类型_自营服务机构用户_勘查经理
	public final static String USERTYPE_DSFFWJGYH_TKQYJL = "19";    //用户类型_自营服务机构用户_勘查区域经理
	public final static String USERTYPE_GOV = "20";    //用户类型_承办单位政府用户
	public final static String USERTYPE_ORGREGISTER = "21";    //用户类型_服务机构注册人员
	public final static String USERTYPE_NORAML = "22";    //用户类型_普通人员

	/* 用户角色 固定的角色 */
	public final static String USERROLE_PGJG = "pgjg";    //用户角色_评估机构
	public final static String USERROLE_ZG = "zhuguan";    //用户角色_主管
	public final static String USERROLE_JS = "pgjgjsry";    //用户角色_结算人员
	public final static String USERROLE_ZXZY = "zxzy";    //用户角色_撰写专员
	public final static String USERROLE_YSZY = "yszy";    //用户角色_一审专员
	public final static String USERROLE_FHRY = "fhry";    //用户角色_复核人员


	/* 服务机构类型 SERVICEORGTYPE */
	public final static String SERVICEORGTYPE_FXPGJG = "1";    //服务机构类型_风险评估机构
	public final static String SERVICEORGTYPE_CYGS = "2";    //服务机构类型_餐饮公司
	public final static String SERVICEORGTYPE_FBGS = "3";    //服务机构类型_防爆公司
	public final static String SERVICEORGTYPE_PWGS = "4";    //服务机构类型_票务公司
	public final static String SERVICEORGTYPE_BAGS = "5";    //服务机构类型_保安公司
	public final static String SERVICEORGTYPE_CZGS = "6";    //服务机构类型_场租公司
	public final static String SERVICEORGTYPE_LJGS = "7";    //服务机构类型_临建公司
	public final static String SERVICEORGTYPE_AJMGS = "8";    //服务机构类型_安检门公司
	public final static String SERVICEORGTYPE_JLGS = "9";    //服务机构类型_监理公司

	/* 服务模式 SERVICEMODE */
	public final static String SERVICEMODE_ZY = "1";    //服务模式_自营
	public final static String SERVICEMODE_DSF = "2";    //服务模式_第三方

	/**
	 * 服务机构权限控制
	 */
	public final static String SERVICEORGAUTH_ZXZX = "SA1";    //在线撰写功能
	public final static String SERVICEORGAUTH_GXMB = "SA2";    //共享模版权限
	public final static String SERVICEORGAUTH_ZSK = "SA3";    //知识库权限
	public final static String SERVICEORGAUTH_XCKC = "SA4";    //现场勘查功能
	public final static String SERVICEORGAUTH_XXZF = "SA5";    //线下支付功能
	public final static String SERVICEORGAUTH_GXZJ = "SA6";    //共享专家权限
	public final static String SERVICEORGAUTH_ZYCW = "SA7";    //自营财务权限


	/*  -------------------------活动类型---------------------**/
	public final static String ACTIVITYTYPE_TYBSHD 	= "100001";     //活动类型_体育比赛活动
	public final static String ACTIVITYTYPE_WYYCHD 	= "100002";    //活动类型_文艺演出活动
	public final static String ACTIVITYTYPE_ZLZXDHD 	= "100003";   //活动类型_展览展销等活动
	public final static String ACTIVITYTYPE_YYDHHD 	= "100004";    //活动类型_游园灯会活动
	public final static String ACTIVITYTYPE_ZPHHD 	= "100005";     //活动类型_招聘会活动
	public final static String ACTIVITYTYPE_GYCSHD 	= "100006";    //活动类型_公益慈善活动
	public final static String ACTIVITYTYPE_QT 		= "100007";     //活动类型_其他

	/* 场地类型 ADDRESSTYPE */
	public final static String ADDRESSTYPE_SN = "1";            //全封闭（室内）
	public final static String ADDRESSTYPE_SNLT = "2";            //半封闭（室内露天）
	public final static String ADDRESSTYPE_SW = "3";            //开放式（室外）
	public final static String ADDRESSTYPE_SNSW = "4";        //室内+室外
	public final static String ADDRESSTYPE_QT = "5";        //其他


	/* 审批状态 APPROVALSTATUS */
	public final static String APPROVALSTATUS_DSH = "1";    //审批状态_待审批
	public final static String APPROVALSTATUS_SHTG = "2";    //审批状态_审批许可
	public final static String APPROVALSTATUS_SHBTG = "3";    //审批状态_审批不许可
	public final static String APPROVALSTATUS_SHDH = "4";    //审批状态_审批打回


	/* 新闻级别 PRIORITYNEWS */
	public final static String PRIORITYNEWS_IMPORTANT = "0";    //新闻级别_重要公告
	public final static String PRIORITYNEWS_NEWEST = "1";        //新闻级别_最新公告
	public final static String PRIORITYNEWS_GENERAL = "2";        //新闻级别_普通


	/* 快递类型 EXPRESS */
	public final static String EXPRESS_SFKD = "1";    //快递类型_顺丰快递  EXPRESS
	public final static String EXPRESS_YTKD = "5";    //快递类型_圆通快递
	public final static String EXPRESS_STKD = "10";    //快递类型_申通快递
	public final static String EXPRESS_YDKD = "15";    //快递类型_韵达快递
	public final static String EXPRESS_ZTKD = "20";    //快递类型_中通快递
	public final static String EXPRESS_TTKD = "25";    //快递类型_天天快递
	public final static String EXPRESS_HTKD = "30";    //快递类型_汇通快递
	public final static String EXPRESS_LB = "35";    //快递类型_联邦
	public final static String EXPRESS_ZJS = "40";    //快递类型_宅急送
	public final static String EXPRESS_EMS = "45";    //快递类型_EMS


	/* 审核结果 APPROVEACTIVE */
	public final static String APPROVEACTIVE_SHZ = "0";    //审核结果_审核中
	public final static String APPROVEACTIVE_SHCG = "1";    //审核结果_审核成功
	public final static String APPROVEACTIVE_SHWTG = "2";    //审核结果_审核未通过


	/* 支付状态 PAYSTATUS */
	public final static String PAYSTATUS_WZF = "0";    //支付状态_未支付
	public final static String PAYSTATUS_YZF = "1";    //支付状态_已支付
	public final static String PAYSTATUS_ZFSB = "2";    //支付状态_支付失败
	public final static String PAYSTATUS_ZFGB = "3";    //支付状态_支付关闭


	/* 阅读状态 READSTATUS */
	public final static String READSTATUS_WD = "0";    //阅读状态_未读
	public final static String READSTATUS_YD = "1";    //阅读状态_已读


	/* 订单状态 ORDERSTATUS */
	public final static String ORDERSTATUS_WZF = "0"; //订单状态_待支付
	public final static String ORDERSTATUS_YZF = "1";     //订单状态_已支付
	public final static String ORDERSTATUS_DWS_TJCL = "2";     //待完善（提交材料）
	public final static String ORDERSTATUS_DWS_XZJG = "3";     //待完善(选择服务机构)
	public final static String ORDERSTATUS_YHZF = "4";     //延后支付
	public final static String ORDERSTATUS_YSC = "9";     //已删除
	public final static String ORDERSTATUS_REFUND = "100";     //退款
	public final static String ORDERSTATUS_CANCEL = "200";     //已取消


	/* 活动状态阶段 ACTIVITYSUBSTEP */
	public final static String ACTIVITYSUBSTEP_CGCJXM = "10";    //活动状态阶段_成功创建了项目
	public final static String ACTIVITYSUBSTEP_CGZFLYF = "15";    //活动状态阶段_成功支付了费用
	public final static String ACTIVITYSUBSTEP_CGTJLCL = "20";    //活动状态阶段_成功提交了材料
	public final static String ACTIVITYSUBSTEP_DYJDTKYWC = "25";    //活动状态阶段_第一阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_FXPGBGYWC = "30";    //活动状态阶段_风险评估报告已完成
	public final static String ACTIVITYSUBSTEP_HDSPBTG = "35";    //活动状态阶段_活动审批不通过
	public final static String ACTIVITYSUBSTEP_HDSPTG = "40";    //活动状态阶段_活动审批通过
	public final static String ACTIVITYSUBSTEP_HDSPDH = "42";    //活动状态阶段_活动审批打回
	public final static String ACTIVITYSUBSTEP_JLSCBYWC = "43";    //活动状态阶段_监理检查表已完成
	public final static String ACTIVITYSUBSTEP_DRJDTKYWC = "45";    //活动状态阶段_第二阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_JCBYWC = "48";     // 活动状态阶段_检查表已完成
	public final static String ACTIVITYSUBSTEP_JLBGYWC = "50";    //活动状态阶段_监理报告已完成
	public final static String ACTIVITYSUBSTEP_DSJDTKYWC = "55";    //活动状态阶段_第三阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_XMJS = "60";    //活动状态阶段_项目结束

	/* 户外场地类型 OUTDOORTYPE */
	public final static String OUTDOORTYPE_XXGC = "1";        //户外场地类型_学校体育场，校内广场
	public final static String OUTDOORTYPE_GYGC = "2";       //户外场地类型_公园，文化广场
	public final static String OUTDOORTYPE_SYQGC = "3";        //户外场地类型_商业区广场
	public final static String OUTDOORTYPE_HBSD = "4";        //户外场地类型_海边沙滩，山地，水上，
	public final static String OUTDOORTYPE_QT = "5";          //户外场地类型_其他


	/* 展会类型 EXHIBITIONTYPE */
	public final static String EXHIBITIONTYPE_ZY = "1";   //专业类
	public final static String EXHIBITIONTYPE_XF = "2";  //消费类
	public final static String EXHIBITIONTYPE_ZH = "3";  //综合类


	/* 报告发送类型 REPORTEXPRESS */
	public final static String REPORTEXPRESS_BJSBG = "0";     // 报告发送类型_不寄送
	public final static String REPORTEXPRESS_JSBG = "1";        //报告发送类型_寄送报告


	/* 发票寄送类型 INVOICEEXPRESS */
	public final static String INVOICEEXPRESS_BJSFP = "0";     //发票寄送类型_不寄送
	public final static String INVOICEEXPRESS_JSPTFP = "1";        //发票寄送类型_普通发票
	public final static String INVOICEEXPRESS_JSZSFP = "2";        //发票寄送类型_增值税发票


	/* 发票类型 INVOICETYPE */
	public final static String INVOICETYPE_PTFP = "1";         //发票类型_普通发票
	public final static String INVOICETYPE_ZZSFP = "2";        //发票类型_增值税发票
	public final static String INVOICETYPE_DZFP = "3";         //发票类型_电子发票


	/* 发票类型 PRIORITY */
	public final static String PRIORITY_PT = "1";//普通
	public final static String PRIORITY_ZX = "2";//最新
	public final static String PRIORITY_ZY = "3"; //重要


	/* 收费标准类型 QUOTATIONCLASS */
	public final static String QUOTATIONCLASS_ACTIVITY = "1";            //价格模板分类_活动

	/* 收费标准类型 QUOTATIONTYPE */
	public final static String QUOTATIONTYPE_XSXC = "1";              //收费标准类型_系数相乘
	public final static String QUOTATIONTYPE_JELJ = "2";              //收费标准类型_金额累加
	public final static String QUOTATIONTYPE_GDJG = "3";              //收费标准类型_固定价格


	/* 加急类型 REPORTURGENT */
	public final static String REPORTURGENT_BXYBG = "00";           //加急类型_不需要报告(针对政府项目)
	public final static String REPORTURGENT_BJJ = "0";              //加急类型_不加急
	public final static String REPORTURGENT_JJSGGZR = "3";         //加急类型_加急(5-7个工作日)


	/* 报告状态类型 REPORTSTATUS */
	public final static String REPORTSTATUS_COLLECT = "1";          //资料收集（资料打回才可能变成在收集状态）
	public final static String REPORTSTATUS_DRAFT = "2";           //撰写中
	public final static String REPORTSTATUS_SUBMIT = "3";         //已提交

	/* 保单人物角色 ROLEKIND */
	public final static String ROLEKIND_INSURED = "0";               //被保人
	public final static String ROLEKIND_APPLICANT = "1";             //投保人
	public final static String ROLEKIND_BENEFICIARY = "2";           //受益人
	public final static String ROLEKIND_GUARANTEE = "3";               //担保人


	/* 保单人物角色亲属关系 RELATEDTOROLECODE */
	public final static String RELATEDTOROLECODE_SPOUSE = "0";            //配偶
	public final static String RELATEDTOROLECODE_CHILD = "1";             //子女
	public final static String RELATEDTOROLECODE_PARENT = "2";             //父母
	public final static String RELATEDTOROLECODE_FAMILY = "3";             //亲属
	public final static String RELATEDTOROLECODE_SELF = "4";              //本人
	public final static String RELATEDTOROLECODE_OTHER = "5";             //其他
	public final static String RELATEDTOROLECODE_GUYONG = "6";             //雇佣关系


	/* 证件类型 IDTYPE */
	public final static String IDTYPE_IDCARD = "0";                                    //身份证
	public final static String IDTYPE_OFFICERCERTIFICATE = "1";                        //军官证
	public final static String IDTYPE_PASSPORT = "2";                                    //护照
	public final static String IDTYPE_CARLICENCE = "3";                                //驾驶执照
	public final static String IDTYPE_HVPSANDMTP = "4";                                //港澳回乡证或台胞证
	public final static String IDTYPE_HOMECARD = "5";                                    //返乡证
	public final static String IDTYPE_OTHER = "6";                                    //其他
	public final static String IDTYPE_BUSINESSLICENSE = "7";                            //营业执照
	public final static String IDTYPE_TAXREGISTRATIONCERTIFICATE = "8";             //税务登记证
	public final static String IDTYPE_ORGANIZATIONCODECERTIFICATE = "9";            //组织机构代码证


	/* 性别 GENDER */
	public final static String GENDER_FEMALE = "0";                                //女
	public final static String GENDER_MALE = "1";                                    //男
	public final static String GENDER_UNKNOWN = "3";                                //未知


	/* 保单活动类型 POLICY_ACTIVITYTYPE */
	public final static String POLICY_ACTIVITYTYPE_EXHIBITION = "0";                            //展览展销类
	public final static String POLICY_ACTIVITYTYPE_LITERATURE = "1";                            //文艺演出类
	public final static String POLICY_ACTIVITYTYPE_SPORTS = "2";                                //体育赛事类
	public final static String POLICY_ACTIVITYTYPE_GARDENLANTERN = "3";                        //其他类活动（游园、灯会、庙会、花会、焰火晚会、人才招聘会、现场开奖的彩票销售等）
	public final static String POLICY_ACTIVITYTYPE_OTHER = "4";                                //其他


	/* 保单活动规模 POLICY_ACTIVITYSCALE */
	public final static String POLICY_ACTIVITYSCALE_CPIC_BELOW = "0";                         //5000人以下
	public final static String POLICY_ACTIVITYSCALE_CPIC_MIDDLE = "1";                        //5000人-30000人
	public final static String POLICY_ACTIVITYSCALE_CPIC_UP = "2";                            //30000人以上
	public final static String POLICY_ACTIVITYSCALE_HT_BELOW = "3";                           //5000人以下（含5000人）
	public final static String POLICY_ACTIVITYSCALE_HT_MIDDLE = "4";                          //5000人-10000人（含10000人）
	public final static String POLICY_ACTIVITYSCALE_HT_SE_MIDDLE = "5";                       //10000人-50000人（含50000人）
	public final static String POLICY_ACTIVITYSCALE_HT_UP = "6";                               //50000人以上


	/* 保单活动天数 POLICY_ACTIVITYPERIOD */
	public final static String POLICY_ACTIVITYPERIOD_BELOW = "0";                           //三天以内
	public final static String POLICY_ACTIVITYPERIOD_MIDDLE = "1";                          //三天-七天
	public final static String POLICY_ACTIVITYPERIOD_UP = "2";                                //七天以上


	/* 有无消防措施 POLICY_ACTIVITYFIREFIGHT */
	public final static String POLICY_ACTIVITYFIREFIGHT_ACCEPTANCE = "0";                           //有消防验收
	public final static String POLICY_ACTIVITYFIREFIGHT_EXTINGUISHER = "2";                         //无消防验收但配备灭火器
	public final static String POLICY_ACTIVITYFIREFIGHT_NO_EXTINGUISHER = "3";                      //无消防验收无灭火器


	/* 场地类型 POLICY_ACTIVITYLOCAL */
	public final static String POLICY_ACTIVITYLOCAL_INDOOR = "0";                           //室内场馆
	public final static String POLICY_ACTIVITYLOCAL_OPEN = "1";                            //露天场馆
	public final static String POLICY_ACTIVITYLOCAL_OUTDOOR = "2";                          //户外地点


	/* 保单赔偿金额 POLICY_ACTIVITYQUOTA */
	public final static String POLICY_ACTIVITYQUOTA_PIC_LEVEL_ONE = "0";                //人民币400万≤累计赔偿限额＜人民币600万
	public final static String POLICY_ACTIVITYQUOTA_CPIC_LEVEL_TWO = "1";               //人民币600万≤累计赔偿限额＜人民币800万
	public final static String POLICY_ACTIVITYQUOTA_CPIC_LEVEL_THREE = "2";             //人民币800万≤累计赔偿限额＜人民币1000万
	public final static String POLICY_ACTIVITYQUOTA_CPIC_LEVEL_FOUR = "3";              //人民币1000万≤累计赔偿限额＜人民币1500万
	public final static String POLICY_ACTIVITYQUOTA_PIC_LEVEL_FIVE = "4";               //人民币1500万≤累计赔偿限额＜人民币2000万
	public final static String POLICY_ACTIVITYQUOTA_PIC_LEVEL_SIX = "5";                //累计赔偿限额≥人民币2000万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_ONE = "6";                 //人民币500万≤累计赔偿限额＜人民币3500万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_TWO = "7";                 //人民币1000万≤累计赔偿限额＜人民币3500万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_THREE = "8";               //人民币1500万≤累计赔偿限额＜人民币3500万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_FOUR = "9";                //人民币3500万<累计赔偿限额


	/* 区域级别  regionLevel */
	public final static String REGIONLEVEL_PROVINCE = "1";	 // 省份
	public final static String REGIONLEVEL_CITY = "2";     // 城市
	public final static String REGIONLEVEL_AREA = "3";     // 区县
	public final static String REGIONLEVEL_UNIT = "4";     // 许可单位

	/* 有无状态 WHETHER */
	public final static String WHETHER_HAVE = "1";                //有
	public final static String WHETHER_WITHOUT = "0";               //无


	/*勘查阶段 SURVEYSTEP*/
	public final static String SURVEYSTEP_FIRST = "1"; //第一阶段勘查
	public final static String SURVEYSTEP_SECOND = "2"; //第二阶段勘查
	public final static String SURVEYSTEP_THIRD = "3"; //第三阶段勘查


	/* 任务接受状态 ACCEPTSTATUS */
	public final static String ACCEPTSTATUS_NON = "0"; //未接收
	public final static String ACCEPTSTATUS_YES = "1"; //已接收
	public final static String ACCEPTSTATUS_TRANSFER = "2"; //申请转交


	/* 任务状态 TASKSTATUS */
	public final static String TASKSTATUS_NON = "1"; //未完成
	public final static String TASKSTATUS_CONTINUE = "2"; //进行中
	public final static String TASKSTATUS_COMPLETE = "3"; //已完成
	public final static String TASKSTATUS_CLOSE = "4"; //任务关闭
	public final static String TASKSTATUS_ASSIGNED = "5"; //已分配
	public final static String TASKSTATUS_NON_ACCEPT = "6"; //待接单
	public final static String TASKSTATUS_REFUSE = "7"; //已拒绝


	/* 任务类型 TASKTYPE */
	public final static String TASKTYPE_FILEUPLOAD = "1"; // 材料上传
	public final static String TASKTYPE_SURVEY = "2"; // 现场勘查
	public final static String TASKTYPE_FILEVERIFY = "3"; // 材料审核
	public final static String TASKTYPE_FIRSTDRAFT = "4"; // 撰写初稿
	public final static String TASKTYPE_FIRSTAUDIT = "5"; // 报告一审
	public final static String TASKTYPE_EXPERTAUDIT = "6"; // 专家审核
	public final static String TASKTYPE_REVIEW = "7"; // 报告复核
	public final static String TASKTYPE_PRINT = "8"; // 报告导出打印
	public final static String TASKTYPE_VIDEO = "9"; // 视频任务
	public final static String TASKTYPE_NOTHING = "10"; // 没用
	public final static String TASKTYPE_CONSULT = "11"; // 专家咨询



	/* 勘查任务状态 SURVEYTASKSTATUS */
	public final static String SURVEYTASKSTATUS_XRW = "1"; //新任务
	public final static String URVEYTASKSTATUS_CS = "2"; //超时
	public final static String URVEYTASKSTATUS_JXZ = "3"; //进行中
	public final static String URVEYTASKSTATUS_TKJSYJB = "4"; //勘察结束已办结
	public final static String URVEYTASKSTATUS_YJJ = "5"; //已拒绝
	public final static String URVEYTASKSTATUS_YZJ = "6"; //已转交
	public final static String URVEYTASKSTATUS_ZJSHZ = "7"; //转交审核中
	public final static String URVEYTASKSTATUS_YGHDSJ = "8"; //已过活动时间
	public final static String URVEYTASKSTATUS_QT = "9"; //其他
	public final static String URVEYTASKSTATUS_QB = "10"; //全部


	/* 分配状态 ASSIGNSTATUS */
	public final static String ASSIGNSTATUS_UNDISTRIBUTED = "1"; //未分配
	public final static String ASSIGNSTATUS_NOTPASS = "2"; //不通过
	public final static String ASSIGNSTATUS_PASS = "3"; //通过
	public final static String ASSIGNSTATUS_CLOSE = "4"; //关闭


	/* 分配类型 ASSIGNTYPE */
	public final static String ASSIGNTYPE_REWJ = "1"; //任务转交
	public final static String ASSIGNTYPE_SQZJ = "2"; //申请专家


	/* 勘查问题类型 ASSIGNSTATUS */
	public final static String QUESTIONTYPE_OPEN_QUESTION = "1"; //开放问题
	public final static String QUESTIONTYPE_FIXED_QUESTION = "2"; //固定问题
	public final static String QUESTIONTYPE_SUPPLEMENTARY_QUESTION = "3"; //补充问题
	public final static String QUESTIONTYPE_LEGACY_QUESTION = "4"; //遗留问题

	/* 性别 SEX */
	public final static String SEX_MEN = "1";           //性别_男
	public final static String SEX_WOMEN = "2";             //性别_女
	public final static String SEX_QT = "3";          //性别_不确定

	/* 学历 EDUCATION */
	public final static String EDUCATION_BSYJS = "1";             //学历_博士研究生
	public final static String EDUCATION_SSYJS = "2";             //学历_硕士研究生
	public final static String EDUCATION_DXBK = "3";             //学历_大学本科
	public final static String EDUCATION_DXZK = "4";             //学历_大学专科
	public final static String EDUCATION_ZDZK = "5";             //学历_中等专科
	public final static String EDUCATION_ZYGZ = "6";            //学历_职业高中
	public final static String EDUCATION_JGXX = "7";             //学历_技工学校
	public final static String EDUCATION_PTZX = "8";             //学历_普通中学
	public final static String EDUCATION_CJZX = "9";            //学历_初级中学
	public final static String EDUCATION_XX = "10";            //学历_小学
	public final static String EDUCATION_QT = "11";            //学历_其他

	/* 政治面貌 POLITICAL */
	public final static String POLITICAL_ZGDY = "1";             //政治面貌_中共党员
	public final static String POLITICAL_ZGYBDY = "2";             //政治面貌_中共预备党员
	public final static String POLITICAL_GQTY = "3";            //政治面貌_共青团员
	public final static String POLITICAL_MGDY = "4";             //政治面貌_民革党员
	public final static String POLITICAL_MMMY = "5";             //政治面貌_民盟盟员
	public final static String POLITICAL_MJHY = "6";            //政治面貌_民建会员
	public final static String POLITICAL_MJHY2 = "7";             //政治面貌_民进会员
	public final static String POLITICAL_NGDDY = "8";           //政治面貌_农工党党员
	public final static String POLITICAL_ZGDDY = "9";            //政治面貌_致公党党员
	public final static String POLITICAL_JSXSDY = "10";            //政治面貌_九三学社社员
	public final static String POLITICAL_TMMY = "11";            //政治面貌_台盟盟员
	public final static String POLITICAL_WDPRS = "12";             //政治面貌_无党派人士
	public final static String POLITICAL_QZ = "13";             //政治面貌_群众

	/* 专家任务类型 EXPERTTASKTYPE */
	public final static String EXPERTTASKTYPE_TK = "1";             //专家任务类型_勘查
	public final static String EXPERTTASKTYPE_ZX = "2";             //专家任务类型_撰写
	public final static String EXPERTTASKTYPE_TKZX = "3";             //专家任务类型_勘查和撰写


	/*************************报告撰写****************************/

	/* 报告撰写小状态 REPORTSUBSTATUS */
	public final static String REPORTSUBSTATUS_ASSIGN = "1";    //待分配
	public final static String REPORTSUBSTATUS_DRAFT = "2";    //初稿撰写
	public final static String REPORTSUBSTATUS_FIRST = "3";     //一审
	public final static String REPORTSUBSTATUS_EXPERT = "4";    //专家审核
	public final static String REPORTSUBSTATUS_EXPERT_40 = "40";    //待专家接单
	public final static String REPORTSUBSTATUS_EXPERT_41 = "41";    //专家已拒绝
	public final static String REPORTSUBSTATUS_REVIEW = "5";    //复核
	public final static String REPORTSUBSTATUS_COMPLETE = "6";    //行政人员 完成

	/* 报告撰写目录级别 COMPOSECATALOGLEVEL */
	public final static String COMPOSECATALOGLEVEL_ONE = "1";    //章
	public final static String COMPOSECATALOGLEVEL_TWO = "2";    //节
	public final static String COMPOSECATALOGLEVEL_THREE = "3";     //项
	public final static String COMPOSECATALOGLEVEL_PARAGRAPH = "4";    //段

	/* 元素类型*/
	public final static String FIELDTYPE_TEXT = "text";    //元素类型_单行文本
	public final static String FIELDTYPE_TEXTAREA = "textarea";    //元素类型_多行文本
	public final static String FIELDTYPE_NUMBER = "number";    //元素类型_数值
	public final static String FIELDTYPE_RADIO = "radio";    //元素类型_单选框
	public final static String FIELDTYPE_SELECT = "select";    //元素类型_下拉框
	public final static String FIELDTYPE_TIME = "time";    //元素类型_时间
	public final static String FIELDTYPE_PIC = "pic";    //元素类型_图片
	public final static String FIELDTYPE_CHECKBOX = "checkbox";    //元素类型_多选狂
	public final static String FIELDTYPE_FILE = "file";    //元素类型_文件

	/**
	 * 报告文件级别
	 */
	public final static String COMPOSEFILELEVEL_ONE = "1";    //报告文件级别_报告编写人员
	public final static String COMPOSEFILELEVEL_TWO = "2";    //报告文件级别_报告审核人员
	public final static String COMPOSEFILELEVEL_THREE = "3";  //报告文件级别_评估技术专家
	public final static String COMPOSEFILELEVEL_FOUR = "4";   //报告文件级别_评估组长

	/* 素材对象 COMPOSECATEGORY  */
	public final static String COMPOSECATEGORY_QY = "1";    //素材元素类型_企业
	public final static String COMPOSECATEGORY_CG = "2";    //素材元素类型_场馆

	//,,,


	/* 内容类型 CONTENTTYPE  */
	public final static String CONTENTTYPE_DLMB = "1";    //内容类型_段落模板
	public final static String CONTENTTYPE_QY = "2";      //内容类型_企业
	public final static String CONTENTTYPE_CG = "3";      //内容类型_场馆
	public final static String CONTENTTYPE_AL = "4";      //内容类型_案例
	public final static String CONTENTTYPE_LSBG = "5";      //内容类型_历史报告
	public final static String CONTENTTYPE_QW = "6";      //内容类型_全文

	/* 任务完成程度  COMPLETE */
	public final static String COMPLETE_YES = "1";     //任务完成程度_已全部完成
	public final static String COMPLETE_NO = "0";    //任务完成程度_未完成
	public final static String COMPLETE_PROCESS = "2";   //任务完成程度_未完成部分


	/* 顺序调整  seq */
	public final static String SEQ_ADD = "1";     //顺序调整_增加
	public final static String SEQ_DECREASE = "0";    //顺序调整_减少


	/* 材料类型 */
	public final static String MATERIALTASKTYPE_PGCL = "1";     //生成评估材料


	/* 同步类型 */
	public final static String SYNCTASKTYPE_PGBG = "1";     //评估报告接口
	public final static String SYNCTASKTYPE_TKBG = "2";    //勘查报告
	public final static String SYNCTASKTYPE_JLBG = "3";   //监理报告
	public final static String SYNCTASKTYPE_WXTS = "5";   //温馨提示信息同步
	public final static String ASSESSMENT_UPDATE = "6";   //便民服务信息同步
	public final static String ASSESSMENT_DELETE = "7";   //便民服务信息同步(删除)
	public final static String SYSTIPS = "8";   //系统升级提示
	public final static String SYNCSERVICEORG = "9";   //同步服务机构
	public final static String SYNCTASKTYPE_NEWS = "10";   //同步资讯公告
	public final static String SYNCTASKTYPE_DELNEWS = "15";   //同步资讯公告
	public final static String SYNCTASKTYPE_FLUSHNEWS = "16";   //清空资讯公告
	public final static String SYNCTASKTYPE_HDLS = "17";   //活动历史数据同步
	public final static String SYNCTASKTYPE_FLUSH_ASSESSMENT = "18";   //清空便民服务
	public final static String SYNCTASKTYPE_UPDATE_CONTRACTOR = "19";   //修改承办方信息
	public final static String SYNCTASKTYPE_ACTIVITY_COOPER = "20";   //活动与服务机构关系

	public final static String SYNCTASKTYPE_SECURITY_TASK = "31";   //安保任务
	public final static String SYNCTASKTYPE_SECURITY_PERSON = "32";   //安保人员
	public final static String SYNCTASKTYPE_SECURITY_TASK_PERSON = "33";   //安保任务-人员
	public final static String SYNCTASKTYPE_SECURITY_TASK_PERSON_TRACK = "34";   //安保任务-人员-轨迹


	public final static String SYNCTASKTYPE_XGMM = "U1";   //修改密码
	public final static String SYNCTASKTYPE_YHDJ = "U2";   //用户冻结
	public final static String SYNCTASKTYPE_YHSH = "U3";   //用户审核
	public final static String SYNCTASKTYPE_GAJG = "U4";   //公安机关用户注册
	public final static String SYNCTASKTYPE_CBFZC = "U5";   //承办方注册
	public final static String SYNCTASKTYPE_ZFCBFZC = "U6";   //政府单位承办方注册
	public final static String SYNCTASKTYPE_MOBILE = "U7";   //修改手机号

	public final static String SYNCTASKTYPE_FILE = "99";     //文件
	public final static String SYNCTASKTYPE_ACTID = "33";    //获得子站的活动id

	public final static String COMPOSERISK_TYPE_ELEMENT = "COMPOSERISK_TYPE_ELEMENT_";     //风险因素type

	/* 短信配置类型 */
	public final static String NOTIFY_SETUP_TYPE_ACTIVITY_CREATE = "1";     //申报系统创建的活动同步到管理后台
	public final static String NOTIFY_SETUP_TYPE_FIRST_TRIAL= "2";     //承办方提交活动初审，客服保险跟催
	public final static String NOTIFY_SETUP_TYPE_INVOICE_REVIEW = "3";     //有新的发票需要审核时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_ORG_REVIEW = "4";     //有新的服务机构账号需要审核时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_GOV_REVIEW = "5";     //有新的政府单位账号需要审核时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_BUSINESS_LICENSE_REVIEW= "6";	//有新的营业执照需要审核时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_EXPERT_REVIEW = "7";	//有新的专家需要审核时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_ACTIVITY_STATUS_CHANGE = "8";    //活动状态变更时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_ORDER_STATUS_CHANGE = "9";    //订单状态变更时，通知联系人
	public final static String NOTIFY_SETUP_TYPE_ORG_REGISTER = "10";    //机构注册，通知联系人


	/* 通知类型 */
	public final static String NOTIFY_SYNC_WARNING = "1"; /* 同步告警通知 */

	//场地类型 展馆
	public final static String VENUETYPE_EXHIBITION = "2";
	//场地类型 展厅
	public final static String VENUETYPE_EXHIBITIONHALL = "4";

	//共享
	public final static String NATURE_PUBLIC = "0";
	//私有
	public final static String NATURE_PRIVATE = "1";


	/*********************知识文库类型************************/
	public final static String KNOWLEDGE_TYPE_AQPG = "1";
	public final static String KNOWLEDGE_TYPE_RYGK = "2";
	public final static String KNOWLEDGE_TYPE_CDBJ = "3";
	public final static String KNOWLEDGE_TYPE_JJSS = "4";
	public final static String KNOWLEDGE_TYPE_AQZY = "5";


	/**************************管理后台活动信息排序规则***********/

	public final static String SORT_1 = "1";    //下单日期降序
	public final static String SORT_2 = "2";    //下单日期升序
	public final static String SORT_3 = "3";    //距离举办天数升序
	public final static String SORT_4 = "4";    //距离举办天数降序
	public final static String SORT_5 = "5";    //活动开始时间升序
	public final static String SORT_6 = "6";    //活动开始时间降序
	public final static String SORT_7 = "7";    //活动结束时间升序
	public final static String SORT_8 = "8";    //活动结束时间降序
	public final static String SORT_9 = "9";    //订单金额降序
	public final static String SORT_10 = "10";   //订单金额升序


	/******************** 订单发票审核 ***********************/

	public final static String INVOICE_APPROVAL_TYPE_DSH = "1";   //待审核
	public final static String INVOICE_APPROVAL_TYPE_SHTG = "2";   //审核通过
	public final static String INVOICE_APPROVAL_TYPE_SHTH = "3";   //审核退回
	public final static String INVOICE_APPROVAL_TYPE_WKP = "4";   //未开票
	public final static String INVOICE_APPROVAL_TYPE_YKP = "5";   //已开票


	/******************** SaaS注册的机构类型  ***********************/

	/**
	 * 承办方
	 */
	public final static String SAAS_ORG_TYPE_CONTRACTOR = "1";
	/**
	 * 政府单位
	 */
	public final static String SAAS_ORG_TYPE_GOV = "2";
	/**
	 * 服务机构
	 */
	public final static String SAAS_ORG_TYPE_SERVICE = "3";
	/**
	 * 评估机构
	 */
	public final static String SAAS_ORG_TYPE_ASSESSMENT = "4";

	/**
	 * 搭建商
	 */
	public final static String SAAS_ORG_TYPE_LJ = "5";




	/******************** 用户审核状态 ***********************/
	/**
	 * 完善信息、待完善
	 */
	public final static String CHECKSTATUS_ENTERINFO = "0";
	/**
	 * 未审核、待审核
	 */
	public final static String CHECKSTATUS_UNCHECKED = "1";
	/**
	 * 审核通过
	 */
	public final static String CHECKSTATUS_PASS = "2";
	/**
	 * 审核不通过
	 */
	public final static String CHECKSTATUS_NOPASS = "3";

	/******************** 专家订单状态 ***********************/

	/**
	 * 待处理
	 */
	public final static String EXPERT_ORDER_STATUS_0 = "0";
	/**
	 * 已接受
	 */
	public final static String EXPERT_ORDER_STATUS_1 = "1";
	/**
	 * 已拒绝
	 */
	public final static String EXPERT_ORDER_STATUS_2 = "2";
	/**
	 * 待结算
	 */
	public final static String EXPERT_ORDER_STATUS_3 = "3";
	/**
	 * 已取消
	 */
	public final static String EXPERT_ORDER_STATUS_4 = "4";
	/**
	 * 已结算
	 */
	public final static String EXPERT_ORDER_STATUS_5 = "5";


	/**
	 * 系统升级站点
	 **/

	/**
	 * 风评系统
	 */
	public final static String WEBSITE_TYPE_MAIN = "风评系统";

	/**
	 * 申报系统-陕西
	 */
	public final static String WEBSITE_TYPE_SHANXI = "申报系统-陕西";

	/**
	 * 申报系统-广西
	 */
	public final static String WEBSITE_TYPE_GUANGXI = "申报系统-广西";


	/**
	 * 关联撰写任务-评估技术专家
	 */
	public final static String EXPERTTYPE_1 = "16";
	/**
	 * 关联勘查任务-勘查人员
	 */
	public final static String EXPERTTYPE_2 = "14";

	/**
	 * 关联勘查任务-勘查专家
	 */
	public final static String EXPERTTYPE_3 = "17";


	/****区域代码*/

	/**
	 * 全国代码
	 */
	public final static String REGION_CHINA = "100000";

	public final static String ACCOUNT_SOURCE_SB="SB";
	public final static String ACCOUNT_SOURCE_PSS="PSS";
	public final static String ACCOUNT_SOURCE_SAAS="SAAS";

	/**
	 * 专家来源：公有和私有
	 */
	public final static String EXPERT_SOURCE_PUBLIC="public";
	public final static String EXPERT_SOURCE_PRIVATE="private";

	/**
	 * 华为云短信模板
	 */
	public final static String SMSCODE_P01 = "P01";
	public final static String SMSCODE_B01 = "B01";
	public final static String SMSCODE_B02 = "B02";
	public final static String SMSCODE_B03 = "B03";
	public final static String SMSCODE_B04 = "B04";
	public final static String SMSCODE_B05 = "B05";
	public final static String SMSCODE_B06 = "B06";
	public final static String SMSCODE_B07 = "B07";
	public final static String SMSCODE_B08 = "B08";
	public final static String SMSCODE_B09 = "B09";
	public final static String SMSCODE_B10 = "B10";
	public final static String SMSCODE_B11 = "B11";
	public final static String SMSCODE_B12 = "B12";
	public final static String SMSCODE_B13 = "B13";
	public final static String SMSCODE_B14 = "B14";
	public final static String SMSCODE_B15 = "B15";
	public final static String SMSCODE_B16 = "B16";
	public final static String SMSCODE_B17 = "B17";
	public final static String SMSCODE_B18 = "B18";
	public final static String SMSCODE_B19 = "B19";
	public final static String SMSCODE_B20 = "B20";
	public final static String SMSCODE_B21 = "B21";
	public final static String SMSCODE_B22 = "B22";
	public final static String SMSCODE_B23 = "B23";
	public final static String SMSCODE_B24 = "B24";
	public final static String SMSCODE_B25 = "B25";
	public final static String SMSCODE_B26 = "B26";
	public final static String SMSCODE_B27 = "B27";
	public final static String SMSCODE_B28 = "B28";
	public final static String SMSCODE_B29 = "B29";
	public final static String SMSCODE_B30 = "B30";
	public final static String SMSCODE_B31 = "B31";
	public final static String SMSCODE_B32 = "B32";
	public final static String SMSCODE_B33 = "B33";
	public final static String SMSCODE_B34 = "B34";
	public final static String SMSCODE_B35 = "B35";
	public final static String SMSCODE_B36 = "B36";
	public final static String SMSCODE_B37 = "B37";
	public final static String SMSCODE_B38 = "B38";
	public final static String SMSCODE_B39 = "B39";
	public final static String SMSCODE_B40 = "B40";
	public final static String SMSCODE_B41 = "B41";
	public final static String SMSCODE_B42 = "B42";
	public final static String SMSCODE_B43 = "B43";
	public final static String SMSCODE_B44 = "B44";
	public final static String SMSCODE_B45 = "B45";
	public final static String SMSCODE_B46 = "B46";
	public final static String SMSCODE_B47 = "B47";
	public final static String SMSCODE_B48 = "B48";
	public final static String SMSCODE_B49 = "B49";
	public final static String SMSCODE_B50 = "B50";
	public final static String SMSCODE_B51 = "B51";
	public final static String SMSCODE_B52 = "B52";
	public final static String SMSCODE_B53 = "B53";
	public final static String SMSCODE_B54 = "B54";
	public final static String SMSCODE_B55 = "B55";
	public final static String SMSCODE_B56 = "B56";
	public final static String SMSCODE_B57 = "B57";
	public final static String SMSCODE_B58 = "B58";
	public final static String SMSCODE_B59 = "B59";
	public final static String SMSCODE_B60 = "B60";
	public final static String SMSCODE_B61 = "B61";
	public final static String SMSCODE_B62 = "B62";
	public final static String SMSCODE_B63 = "B63";
	public final static String SMSCODE_B64 = "B64";

	/**
	 * 内网审批状态
	 * @return
	 */
	public static Map<String,String> getSbApproveStatusMap(){
		Map<String,String> map = new HashMap<String,String>();
		map.put("1","待审批");
		map.put("2","审批许可");
		map.put("3","审批不许可");
		map.put("4","审批退回");
		map.put("10","初审中");
		map.put("20","初审退回");
		map.put("30","初审通过");
		map.put("SL10","受理中");
		map.put("SL20","不予受理");
		map.put("SL30","受理成功");
		return map;
	}

	public final static Integer FLOW_STATUS_DOING = 1;//签署中
	public final static Integer FLOW_STATUS_OK = 2;//已完成: 所有签署人完成签署
	public final static Integer FLOW_STATUS_CANCEL = 3;//已撤销: 发起方撤销签署任务
	public final static Integer FLOW_STATUS_ABORT = 4;//已终止: 至少一个签署人拒签或通过重试不可恢复的签署失败
	public final static Integer FLOW_STATUS_EXPIRE = 5;//已过期: 超时未签署
	public final static Integer FLOW_STATUS_DELETED = 6;//已删除
	public final static Integer FLOW_STATUS_REFUSE = 7;//已拒签

	public final static Integer SIGN_RESULT_FINISH = 2;//签署完成
	public final static Integer SIGN_RESULT_FAIL = 3;//失败
	public final static Integer SIGN_RESULT_REFUSE = 4;//已拒签

	/**
	 * 活动管理列表排序标签
	 * @return
	 */
	public final static String ACTIVITY_SORTVALUE_1 = "1";//开始时间升序
	public final static String ACTIVITY_SORTVALUE_2 = "2";//开始时间降序
	public final static String ACTIVITY_SORTVALUE_3 = "3";//创建时间升序
	public final static String ACTIVITY_SORTVALUE_4 = "4";//创建时间降序
	public final static String ACTIVITY_SORTVALUE_5 = "5";//活动状态升序
	public final static String ACTIVITY_SORTVALUE_6 = "6";//活动状态降序


	public final static String SYS_NAME="SYS_PSS";

}