package com.bcxin.risk.common.util;

import java.util.HashMap;


/**
 * 平台服务类
 * @author Ethan
 */
public class PlatformUtil {
	
	public static HashMap<String, Integer> PRICE_MAP = new HashMap<String, Integer>();  
	
	static {
		PRICE_MAP.put("contract", 300);
		PRICE_MAP.put("monitorBase", 0); //目前没有视频监控，先设置价格为0
		PRICE_MAP.put("amountBase", 5000);
	}
	
	/**
	 * 获取合同认证费用
	 * @return
	 */
	public static int getContractPrice() {
		return PRICE_MAP.get("contract");
	}
	
	/**
	 * 获取视频监控费用
	 * @param amount
	 * @param days
	 * @return
	 */
	public static int getMonitorPrice(int amount, int days) {
		int price = 0;
		if(amount > PRICE_MAP.get("amountBase")) {
			price = PRICE_MAP.get("monitorBase") * days;
		}
		return price;
	}

}
