package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.sys.SysBasicUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;

@Slf4j
@Component
public class EmailUtil {

    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";


    /**
     * 发送邮件
     * 
     * @param subject
     *            邮件主题
     * @param body
     *            邮件内容
     * @param to
     *            收件人地址
     *            附件
     */
    @Async
    public void sendEmail(String subject, String body, String to) {
        //如果是开发环境，屏蔽调用邮件接口
        if (Objects.equals(ConfigResources.PROFILE_ENVI,"dev")) {
            return;
        }
        if (StringUtil.isEmpty(to)) {
            return;
        }
        if (!to.matches("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+")) {
            log.error("邮箱（"+to+"）校验未通过，格式不对!");
            return;
        }
        try {
            // 创建信件服务器
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", ConfigResources.MAIL_HOST);
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            // 得到默认的对话对象
            Authenticator a = new Authenticator() {
                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ConfigResources.MAIL_USERNAME, ConfigResources.MAIL_PASSWORD);
                }
            };
            //创建Session实例
            Session session = Session.getDefaultInstance(props, a);
            //创建MimeMessage实例对象
            MimeMessage msg = new MimeMessage(session);

            //设置自定义发件人昵称
            String nick = "";
            try {
                nick = javax.mail.internet.MimeUtility.encodeText(SysBasicUtil.getConfig("platform_name"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            //设置发信人
            msg.setFrom(new InternetAddress(nick + " <" + ConfigResources.MAIL_FROM + ">"));
            //设置收信人
            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
            //设置发送日期
            msg.setSentDate(new Date());
            //设置邮件主题
            msg.setSubject(subject);
            //设置邮件正文
            msg.setText(body);
            Transport.send(msg);

            log.debug("邮件发送成功，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("邮件发送失败，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
            log.error("邮件发送失败，异常[{}]",e.getMessage());
        }
    }

}
