package com.bcxin.risk.common.util;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.FileInfo;
import com.cunnar.domain.FileStream;
import com.cunnar.domain.InputStreamCallBack;
import com.cunnar.module.*;
import org.apache.commons.codec.digest.DigestUtils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author xuerdong
 * @date 2017/7/8 15:45
 */
public class CunnarUtil {
    private static AccessToken accessToken;

    private static synchronized AccessToken getAccessToken() {
        if (accessToken == null || accessToken.isExpired()) {
            String userId = CunnarConfig.getValue("userId");
            accessToken = Oauth.getAccessToken(userId);
        }
        return accessToken;
    }

    public static String uploadStream(String localFileId, String pathname) {
        String fileid = null;
        java.io.File file = new java.io.File(pathname);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileInfo info = new FileInfo(localFileId, file.getName(), file.length(), DigestUtils.sha1Hex(fileInputStream));
            fileid = File.create(getAccessToken(), info);
            long uploadlength=File.uploadStream(getAccessToken(), fileid, 0, new FileInputStream(file));
            if(uploadlength==0){
                throw new RuntimeException("上传存证文件失败："+file.getAbsolutePath());
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fileid;
    }

    public static void downloadFileReceipt(String fileId, String pathname) {
        File.downloadFileReceipt(getAccessToken(), fileId, new InputStreamCallBack() {
            public void doInputStream(FileStream fileStream) throws IOException {
                try (InputStream inputStream = fileStream.getInputStream();
                     FileOutputStream stream = new FileOutputStream(pathname)) {
                    int i;
                    byte[] bytes = new byte[1024];
                    while ((i = inputStream.read(bytes)) > 0) {
                        stream.write(bytes, 0, i);
                    }
                    stream.flush();
                } catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }
}
