package com.bcxin.risk.common.util;


import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
public class BcxinHttpUtil {

	/**
	 * POST方式调用
	 *
	 * @param url
	 * @param params
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 * @throws java.io.UnsupportedEncodingException
	 */
	//public static String sendPostRequest(String url, List<NameValuePair> params) {
	//	log.debug("--------开始发送http请求--------");
	//	log.debug("请求地址:[{}]：",url);
	//	logParams(params);
	//	Stopwatch stopwatch = Stopwatch.createStarted();
	//	String result = "";
	//	try (CloseableHttpClient httpClient = createSSLClientDefault()) {
	//		HttpPost httpPost = new HttpPost(url);
	//		httpPost.setEntity(new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
	//		RequestConfig defaultRequestConfig = RequestConfig.custom()
	//				.setSocketTimeout(60000)
	//				.setConnectTimeout(60000)
	//				.setConnectionRequestTimeout(60000)
	//				.build();
	//		httpPost.setConfig(defaultRequestConfig);
	//		try ( CloseableHttpResponse resp = httpClient.execute(httpPost)) {
	//			HttpEntity entity = resp.getEntity();
	//			result = EntityUtils.toString(entity, StandardCharsets.UTF_8);
	//			long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
	//			log.debug("返回结果：[{}]",result);
	//			log.debug("共耗时[{}]毫秒："+ nanos);
	//			log.debug("--------结束http请求--------");
	//		}
	//	} catch (Exception ex) {
	//		ex.printStackTrace();
	//	}
	//	return result;
	//}
	/**
	 * POST方式调用--重构，超时抛异常
	 *
	 * @param url
	 * @param params
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 */
	public static String sendPostRequest(String url, List<NameValuePair> params) {
		log.debug("--------开始发送http请求--------");
		log.debug("请求地址:[{}]：",url);
		logParams(params);
		Stopwatch stopwatch = Stopwatch.createStarted();
		String result = "";
		/* https 的请求 */
		if (url.startsWith("https")) {
			try (CloseableHttpClient httpClient = createSSLClientDefault()) {
				HttpPost httpPost = new HttpPost(url);
				httpPost.setEntity(new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
				RequestConfig defaultRequestConfig = RequestConfig.custom()
						.setSocketTimeout(60000)
						.setConnectTimeout(60000)
						.setConnectionRequestTimeout(60000)
						.build();
				httpPost.setConfig(defaultRequestConfig);
				try ( CloseableHttpResponse resp = httpClient.execute(httpPost)) {
					HttpEntity entity = resp.getEntity();
					result = EntityUtils.toString(entity, StandardCharsets.UTF_8);
					long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
					log.debug("返回结果：[{}]",result);
					log.debug("共耗时[{}]毫秒：", nanos);
					log.debug("--------结束http请求--------");
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		} else {
			/* 普通http的请求 */
			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
				HttpPost httpPost = new HttpPost(url);
				httpPost.setEntity(new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
				RequestConfig defaultRequestConfig = RequestConfig.custom()
						.setSocketTimeout(60000)
						.setConnectTimeout(60000)
						.setConnectionRequestTimeout(60000)
						.build();
				httpPost.setConfig(defaultRequestConfig);
				try ( CloseableHttpResponse resp = httpClient.execute(httpPost)) {
					HttpEntity entity = resp.getEntity();
					result = EntityUtils.toString(entity, StandardCharsets.UTF_8);
					long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
					log.debug("返回结果：[{}]",result);
					log.debug("共耗时[{}]毫秒：", nanos);
					log.debug("--------结束http请求--------");
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
		return result;
	}

	/**
	 * 获取请求参数中所有的信息
	 * @param request
	 * @return
	 */
	public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
		Map<String, String> res = new HashMap<String, String>();
		Enumeration<?> temp = request.getParameterNames();
		if (null != temp) {
			while (temp.hasMoreElements()) {
				String en = (String) temp.nextElement();
				String value = request.getParameter(en);
				res.put(en, value);
				//在报文上送时，如果字段的值为空，则不上送<下面的处理为在获取所有参数数据时，判断若值为空，则删除这个字段>
				//System.out.println("ServletUtil类247行  temp数据的键=="+en+"     值==="+value);
				if (null == res.get(en) || "".equals(res.get(en))) {
					res.remove(en);
				}
			}
		}
		return res;
	}

	private static void logParams(List<NameValuePair> params){
		for(NameValuePair pair:params){
			log.debug("请求的参数名：[{}]，值：[{}]",pair.getName(),pair.getValue());
		}
	}


	/**
	 * 获取用户真实IP地址，不使用request.getRemoteAddr();的原因是有可能用户使用了代理软件方式避免真实IP地址,
	 *
	 * 可是，如果通过了多级反向代理的话，X-Forwarded-For的值并不止一个，而是一串IP值，究竟哪个才是真正的用户端的真实IP呢？
	 * 答案是取X-Forwarded-For中第一个非unknown的有效IP字符串。
	 *
	 * 如：X-Forwarded-For：192.168.1.110, 192.168.1.120, 192.168.1.130,
	 * 192.168.1.100
	 *
	 * 用户真实IP为： 192.168.1.110
	 *
	 * @param request
	 * @return
	 */
	public static String getIpAddress(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_CLIENT_IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_X_FORWARDED_FOR");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}

	//绕过ssl验证
	public static CloseableHttpClient createSSLClientDefault() {
		try {
			SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
				// 信任所有
				@Override
				public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
					return true;
				}
			}).build();
			SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, NoopHostnameVerifier.INSTANCE);
			return HttpClients.custom().setSSLSocketFactory(sslsf).build();
		} catch (KeyManagementException e) {
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (KeyStoreException e) {
			e.printStackTrace();
		}
		return HttpClients.createDefault();
	}

}
