/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.condition.wrapper;

import com.bcxin.risk.hibernateplus.condition.wrapper.SqlPlus;
import com.bcxin.risk.hibernateplus.enums.SqlLike;
import com.bcxin.risk.hibernateplus.utils.MapUtils;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class Wrapper
implements Serializable {
    protected final SqlPlus sql = new SqlPlus();

    public String getSqlSelect() {
        return "";
    }

    public Map<String, String> getSetMap() {
        return Collections.emptyMap();
    }

    public abstract String getSqlSegment();

    public String toString() {
        return this.getSqlSegment();
    }

    public Wrapper where(String sqlWhere, Object ... params) {
        this.sql.WHERE(this.formatSql(sqlWhere, params));
        return this;
    }

    public Wrapper eq(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s = {0}", column), params));
        return this;
    }

    public Wrapper allEq(Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                if (!StringUtils.checkValNotNull(value)) continue;
                this.sql.WHERE(this.formatSql(String.format("%s = {0}", entry.getKey()), entry.getValue()));
            }
        }
        return this;
    }

    public Wrapper gt(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s > {0}", column), params));
        return this;
    }

    public Wrapper ge(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s >= {0}", column), params));
        return this;
    }

    public Wrapper lt(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s < {0}", column), params));
        return this;
    }

    public Wrapper le(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s <= {0}", column), params));
        return this;
    }

    public Wrapper and(String sqlAnd, Object ... params) {
        ((SqlPlus)this.sql.AND()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public Wrapper andNew(String sqlAnd, Object ... params) {
        ((SqlPlus)this.sql.AND_NEW()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public Wrapper or(String sqlOr, Object ... params) {
        ((SqlPlus)this.sql.OR()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public Wrapper orNew(String sqlOr, Object ... params) {
        ((SqlPlus)this.sql.OR_NEW()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public Wrapper groupBy(String columns) {
        this.sql.GROUP_BY(columns);
        return this;
    }

    public Wrapper having(String sqlHaving, Object ... params) {
        this.sql.HAVING(this.formatSql(sqlHaving, params));
        return this;
    }

    public Wrapper orderBy(String columns) {
        this.sql.ORDER_BY(columns);
        return this;
    }

    public Wrapper orderBy(String columns, boolean isAsc) {
        if (StringUtils.isNotBlank(columns)) {
            this.sql.ORDER_BY(columns + (isAsc ? " ASC" : " DESC"));
        }
        return this;
    }

    public Wrapper like(String column, String value) {
        this.sql.LIKE(column, value, SqlLike.DEFAULT);
        return this;
    }

    public Wrapper notLike(String column, String value) {
        this.sql.NOT_LIKE(column, value, SqlLike.DEFAULT);
        return this;
    }

    public Wrapper like(String column, String value, SqlLike type) {
        this.sql.LIKE(column, value, type);
        return this;
    }

    public Wrapper notLike(String column, String value, SqlLike type) {
        this.sql.NOT_LIKE(column, value, type);
        return this;
    }

    public Wrapper isNotNull(String columns) {
        this.sql.IS_NOT_NULL(columns);
        return this;
    }

    public Wrapper isNull(String columns) {
        this.sql.IS_NULL(columns);
        return this;
    }

    public Wrapper exists(String value) {
        this.sql.EXISTS(value);
        return this;
    }

    public Wrapper notExists(String value) {
        this.sql.NOT_EXISTS(value);
        return this;
    }

    public Wrapper in(String column, String value) {
        this.sql.IN(column, value);
        return this;
    }

    public Wrapper notIn(String column, String value) {
        this.sql.NOT_IN(column, value);
        return this;
    }

    public Wrapper in(String column, Collection<?> value) {
        this.sql.IN(column, value);
        return this;
    }

    public Wrapper notIn(String column, Collection<?> value) {
        this.sql.NOT_IN(column, value);
        return this;
    }

    public Wrapper in(String column, Object[] value) {
        this.sql.IN(column, Arrays.asList(value));
        return this;
    }

    public Wrapper notIn(String column, Object ... value) {
        this.sql.NOT_IN(column, Arrays.asList(value));
        return this;
    }

    public Wrapper between(String column, String val1, String val2) {
        this.sql.BETWEEN_AND(column, val1, val2);
        return this;
    }

    public Wrapper addFilter(String sqlWhere, Object ... params) {
        return this.and(sqlWhere, params);
    }

    public Wrapper addFilterIfNeed(boolean need, String sqlWhere, Object ... params) {
        return need ? this.where(sqlWhere, params) : this;
    }

    protected String stripSqlInjection(String value) {
        return value.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }

    protected String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isBlank(sqlStr)) {
            return null;
        }
        return StringUtils.sqlArgsFill(sqlStr, params);
    }
}

