package com.bcxin.risk.user.dto.data;

import lombok.Data;

import java.util.Map;

@Data
public class UserDataDto {

	private String oid; // 用户ID

	private String active; // 是否激活

	private String userName; //用户名
	
	private String realName; //真实姓名

	private String password; //密码
	
	private String phone; // 手机号码

	private String email; //邮箱
	
	private String userType; //用户类型

	private String validateCode; //秘钥

	private String orgAdmin ; //是否机构管理员 0: 否 ，1：是

	private String org_id; //机构ID

	private String ipAddress;

	private String province;  // 省份

	private String city;  // 城市

	private String area;  // 区域

	public UserDataDto(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.active = safeTransfor(map.get("active"));
		this.userName = safeTransfor(map.get("userName"));
		this.realName = safeTransfor(map.get("realName"));
		this.password = safeTransfor(map.get("password"));
		this.phone = safeTransfor(map.get("phone"));
		this.email = safeTransfor(map.get("email"));
		this.userType = safeTransfor(map.get("userType"));
		this.validateCode = safeTransfor(map.get("validateCode"));
		this.orgAdmin = safeTransfor(map.get("orgAdmin"));
		this.org_id = safeTransfor(map.get("org_id"));
		this.ipAddress = safeTransfor(map.get("ipAddress"));
		this.province = safeTransfor(map.get("province"));
		this.city = safeTransfor(map.get("city"));
		this.area = safeTransfor(map.get("area"));
	}

	private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
	
