package com.bcxin.risk.surveytk.enums;

//	新任务：未作出“接受”或“拒绝”反馈的任务
//	进行中：已做出反馈，未完成踏勘的任务；
//	已拒绝：做出“拒绝”反馈的任务
//	已办结：已完成踏勘的任务
//	已转交：转交给其他踏勘人员的任务
public enum SurveyStatusEnum {

    /** 派发 */
    DISTRIBUTE("DISTRIBUTE","新任务"),
    /** 接收超时 */
    OVERTIME("OVERTIME","超时"),
    /** 进行中*/
    DOING("DOING","进行中"),
    /** 勘察结束 已办结 */
    DONE("DONE","已办结"),
    /** 已拒绝 */
    REFUSE("REFUSE","已拒绝"),
    /** 已转交 */
    TRANSFER("TRANSFER","已转交"),
    /** 转交审核中 */
    TRANSFERAUDIT("TRANSFERAUDIT","转交审核中"),
    OBSOLETE("OBSOLETE","已过活动时间"),
    /** 其他*/
    OTHER("OTHER","其他"),
    /** 全部*/
    ALL("ALL","全部");

    private String key;
    private String alias;

    SurveyStatusEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(SurveyStatusEnum e : SurveyStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
