package com.bcxin.risk.survey.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import com.bcxin.risk.user.domain.User;
import lombok.Data;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.report.enums.SurveyTaskStatus;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

/**
 * 勘查任务
 * @author bcxin
 *
 */

@Entity
@Table(name = "RISK_SURVEYTASK")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyTask extends BaseBean{

	private static final long serialVersionUID = 1L;

	private String taskCode; // 任务编号

	@ManyToOne(targetEntity = Task.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "taskId")
	private Task task = new Task(); // 对应任务

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activityId")
	private Activity activity;// 报告

	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	private User user = new User(); // 勘查员工号

	//各勘查计划
	@OneToMany(targetEntity = SurveyPlan.class , cascade = CascadeType.ALL, mappedBy="surveyTask", fetch = FetchType.LAZY)
	@OrderBy("time")
	private List<SurveyPlan> surveyPlan = new ArrayList<SurveyPlan>();

	//各勘查阶段
	@OneToMany(targetEntity = Survey_FeedBack.class , cascade = CascadeType.ALL, mappedBy="surveyTask", fetch = FetchType.LAZY)
	@OrderBy("surveyStep")
	private List<Survey_FeedBack> feedBacks = new ArrayList<Survey_FeedBack>();

	private String name;//项目名称

//	@Enumerated(EnumType.STRING)
//	private SurveyTaskStatus surveyTaskStatus; // 状态

	private String surveyTaskStatus; // 状态

	private Date activityTime;//活动开始时间

	private Date endTime;//活动结束时间

	private String address;//活动地点

	private String contacts;//联系人

	private String contactMobile;//联系电话


}
