package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;

/**
 * 活动材料上传表单属性，元素，模板，当创建新的项目从这里取值，不涉及其他逻辑处理
 * @author Ethan
 */
@Entity
@Table(name = "RISK_MaterialFormAttrTemplate")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormAttrTemplate extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	/**  排序*/
	private int seq;

	/**  元素编码，如A1，A2等*/
	private String attrCode;
	
	/**  元素名称，如公司名称等*/
	private String attrName;

	/**  是否必填*/
	private boolean isRequired;
	
	/**  元素类型，包括（text,number,radio,textarea,select,pic,file,checkbox）*/
	private String type;
	
	/**  脚本事件，如onclick="clickA59(this.value)"*/
	private String events;
	
	/**  具体js脚本 function a()*/
	@Type(type="text")
	private String script;
	
	/**  提示*/
	private String tips;

	/***
	 * 是否在页面显示
	 */
	private String isPageHidden = "1"; //0 代表不展示 ， 1 代表展示 ; 默认展示

	/** 第一主体的元素**/
	private String mainEle; //0代表不是，1代表是，（如果是，则该元素只会在第一个主体中出现，新增主体对象不出现该元素）

	/**
	 * 多选项的类型
	 */
	private String optionType;

	/**
	 * 该属性支持的省份
	 */
	private String supportProvince; //610000,100000 等

	/**
	 * 最大文件上传个数
	 */
	private String maxFilesize;

	/**
	 * 是否锁定，不让修改
	 */
	private String locked;


	@ManyToOne
	@JoinColumn(name = "menuTemplate_id")
	private MaterialFormMenuTemplate materialFormMenuTemplate;
	
}
