package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author LeeJungHyun
 * 承办活动的类型
 **/
public enum ProjectType {
	SPROTS {
		public String getValue(){return "0";}
		public String getName(){return "体育比赛";}
	},OTHER {
		public String getValue(){return "6";}
		public String getName(){return "其他";}
	};
	
	 public abstract String getValue();
	 public abstract String getName();
	 
	 public static ProjectType convert(String value){
	    	if ( "SPROTS".equals(value) ) {
	    		return ProjectType.SPROTS;
	    	} 
	    	return ProjectType.OTHER;
	    }
	 
	 /**
	  * 保众网类型转换
	  * @param idType
	  * @return
	  */
	 public static String convert_bzw(ProjectType projectType){
		String return_code = "";
		switch (projectType) {
		case SPROTS:
			return_code = "0";
			break;
	
		default:
			break;
		}
		 return return_code;
	 }
	 
	 public static List<ProjectType> list(){
	    	List<ProjectType> list = new ArrayList<ProjectType>();
	    	list.add(SPROTS);
	    
	    	return list;
	    }
}
