package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * 公告级别枚举
 * Created by wuqing on 2016/9/2.
 */
public enum PriorityNews {

    IMPORTANT {public String getValue(){return "3";} public String getName(){return "重要公告";}},
    NEWEST {public String getValue(){return "2";} public String getName(){return "最新公告";}},
    GENERAL {public String getValue(){return "1";} public String getName(){return "普通公告";}};

    public abstract String getValue();

    public abstract String getName();

    public static PriorityNews queryCategory(String value){
        if("3".equals(value)){return IMPORTANT;}
        else if("2".equals(value)){return NEWEST;}
        else if("1".equals(value)){return GENERAL;}
        else{return null;}
    }

    public static List<PriorityNews> all(){
        List<PriorityNews> list = new ArrayList<PriorityNews>();
        list.add(IMPORTANT);
        list.add(NEWEST);
        list.add(GENERAL);

        return list;
    }
}
