package com.bcxin.risk.report.enums;


public enum AcceptStatus {
	
	NON {public String getValue(){return "0";} public String getName(){return "未接收";}}, 
	
	YES{public String getValue(){return "1";} public String getName(){return "已接收";}},
	
	/** 已转交 */
	TRANSFER {public String getValue(){return "2";} public String getName(){return "申请转交";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public static AcceptStatus convert(String value){
    	if ( "0".equals(value) ) {
    		return AcceptStatus.NON;
    	} else if ("1".equals(value)) {
    		return AcceptStatus.YES;
    	}else if ("2".equals(value)) {
    		return AcceptStatus.TRANSFER;
    	}
    	return null;
    }
 
}
