package com.bcxin.risk.policy.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author LeeJungHyun
 **/
public enum Gender {

	FEMALE("女", "F", "0"), MALE("男", "M", "1"), UNKNOWN("未知", "N", "3");

	private Gender(String alias, String value, String code) {
		this.alias = alias;
		this.value = value;
		this.code = code;
	}

	private static void init() {
		for (Gender gender : Gender.values()) {
			valueMap.put(gender.value, gender);
			valueMap.put(gender.alias, gender);
			valueMap.put(gender.name(), gender);
			valueMap.put(gender.code, gender);
		}
		init = false;
	}

	private String alias;

	private String value;

	private String code;

	public String getAlias() {
		return alias;
	}

	public String getValue() {
		return value;
	}

	public String code() {
		return code;
	}

	private static Map<String, Gender> valueMap = new HashMap<String, Gender>();
	private static boolean init = true;

	public static Gender relation(String value) {
		if (init) {
			init();
		}
		return valueMap.get(value.trim());
	}

}
