package com.bcxin.risk.policy.enums;


import com.bcxin.risk.policy.domain.InherentType;


/** 
@author LeeJungHyun
 **/
@InherentType
public enum DataType {
	
	STRING(1,"String","java.lang.String"),
	INTEGER(2,"Integer","java.lang.Integer"),
	DOUBLE(3,"Double","java.lang.Double"),
	LONG(4,"Long","java.lang.Long"),
	DECIMAL(5,"BigDecimal","java.math.BigDecimal"),
	BOOLEAN(6,"Boolean","java.lang.Boolean"),
	DATE(7,"Date","java.util.Date"),
	TIMESTAMP(8,"Timestamp","java.sql.Timestamp"),
	TIME(9,"Time","java.sql.Time"),
	REFERENCE(10,"Reference");
	
	
	private DataType(int number,String descrition){
		this.ordinal = number;
		this.name = descrition;
	}
	
	private DataType(int number,String descrition,String type){
		this.ordinal = number;
		this.name = descrition;
		this.type = type;
	}
	
	
	private int ordinal;
	private String type = "java.lang.Object";
	private String name;
	
	
	public static DataType result(String descrition){
		if(descrition == null){
			return null;
		}
		return DataType.valueOf(descrition.toUpperCase());
	}

}


