package com.bcxin.risk.policy.domain;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.risk.policy.enums.Policy_ActivityFireFight;
import com.bcxin.risk.policy.enums.Policy_ActivityLocal;
import com.bcxin.risk.policy.enums.Policy_ActivityPeriod;
import com.bcxin.risk.policy.enums.Policy_ActivityQuota;
import com.bcxin.risk.policy.enums.Policy_ActivityScale;
import com.bcxin.risk.policy.enums.Policy_ActivityType;
import com.bcxin.risk.policy.enums.Whether;

/**
 * 保单额外信息
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_PolicyExtra")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class PolicyExtra extends BaseBean{
	
	private static final long serialVersionUID = 1L;
	
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "report_id")
	private Activity activity; //活动报告
	
	@ManyToOne(targetEntity = InsurancePolicy.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "policy_id")
	private InsurancePolicy policy; 
	
	@Enumerated(EnumType.STRING)
	private Policy_ActivityType activityType;
	
	@Enumerated(EnumType.STRING)
	private Policy_ActivityScale activityScale;
	
	@Enumerated(EnumType.STRING)
	private Policy_ActivityPeriod activityPeriod;
	
	@Enumerated(EnumType.STRING)
	private Policy_ActivityFireFight activityFireFight;
	
	@Enumerated(EnumType.STRING)
	private Policy_ActivityLocal activityLocal;
	
	@Enumerated(EnumType.STRING)
	private Policy_ActivityQuota activityQuota;
	
	@Enumerated(EnumType.STRING)
	private Whether guest;
	
	@Enumerated(EnumType.STRING)
	private Whether danger;
	
	private String peopleNum;
	
	private String reportName;
	
	private String reportActive;
	
	private String reportBeginDate;
	
	private String reportEndDate;
	
	private String reportLocal;//场馆一#室内场馆;场馆二#室外场馆;
	
	private String peoplePeak;
	
	private String dispute;//争议
	
	private String amount;
	
	private String rate;
	
	private String minLimit;
	
	private String maxLimit;
	
	private String activityDays; //活动天数
	
	private String insureDays;//保障天数
	
	private String businessNature; //营业性质
	
	/**
	 * 仲裁机构
	 */
	private  String  policyExtraDispute;
	

	
}
