package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 知识文库
 *
 * @author zhangjianhua
 * @date 2018-9-7
 */
@Entity
@Table(name = "risk_knowledge_base")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class KnowledgeBase extends BaseBean {

    private static final long serialVersionUID = 1L;


    /**
     * 栏目类型
     */
    private String type;

    /**
     * 标题
     */
    private String title;

    /**
     * 内容
     */
    private String content;

}
