package com.bcxin.risk.order.enums;

/**
 * @Author 张建华
 * 知识文库类型
 */
public enum KnowledgeTypeEnum {


    KNOWLEDGE_TYPE_AQPG("1", "安全评估"),
    KNOWLEDGE_TYPE_RYGK("2", "人员管控"),
    KNOWLEDGE_TYPE_CDBJ("3", "场地布局与安全导向标识"),
    KNOWLEDGE_TYPE_LJSS("4", "临建设施指南"),
    KNOWLEDGE_TYPE_AQZY("5", "安保资源配置");

    private String key;
    private String alias;

    KnowledgeTypeEnum(String key, String alias) {
        this.key = key;
        this.alias = alias;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlias() {
        return this.alias;
    }

    public static String getAlias(String key) {
        for (com.bcxin.risk.order.enums.OrderTypeEnum e : com.bcxin.risk.order.enums.OrderTypeEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getAlias();
            }
        }
        return "";
    }
}
