package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 用户操作日志表
 * @author 罗鹏
 */
@Entity
@Table(name = "RISK_UserOpLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class UserOpLog extends BaseBean {

	private static final long serialVersionUID = 1L;


	private String ipAddress;

	/**
	 * 执行菜单
	 */
	private String menu;

	/**
	 * 执行动作
	 */
	private String action;

	/**
	 * 执行对象
	 */
	private String targetObj;

	/**
	 * 请求参数
	 */
	private String param;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "user_id")
	private User user;

}
