package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.enums.PushMethodEnum;
import com.bcxin.risk.enums.PushTypeEnum;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 变更日志
 */
@Entity
@Table(name = "RISK_CHANGE_LOG")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ChangeLog extends BaseBean {

    /**
     * 单据id，如活动id等
     */
    private String billId;

    private String activityNo;

    /**
     * 单据分类
     */
    private String billCategory;

    private String keyName;

    private String text;

    /**
     * 单据类型
     */
    private String billType;

    /**
     * 原始值
     */
    private String sourceVal;

    /**
     * 修改后值
     */
    private String nowVal;

    /**
     * 修改版本
     */
    private int changeVersion;

    /**
     * 修改日期
     */
    private Date changeDate;

    private String isNew;

    private String flagId;

    private String source;

    /**
     * 落地省份id
     */
    private Long markerRegionId;

    /**
     * 1需要推送
     */
    private String isUpdate;

    private String remark;

    /**
     * 是否显示,默认不显示
     * 只有【提交初审、政府提交报备(需要风评)，未落地省份保存】 才会触发
     */
    private String isShow="0";

    public ChangeLog(){

    }

    public ChangeLog(Long markerRegionId,String platform,String key,Object oldVal,Object newVal){
        this.keyName=key;
        if(oldVal!=null) {
            this.sourceVal = oldVal.toString();
        }
        if(newVal!=null) {
            this.nowVal = newVal.toString();
        }
        this.changeDate=new Date();
        this.isNew="1";
        this.isUpdate="1";
        this.isShow="0";
        this.text=getText(key);
        this.source=platform;
        this.markerRegionId=markerRegionId;
    }

    public ChangeLog(Long markerRegionId,String platform,String key,String text,Object oldVal,Object newVal){
        this.keyName=key;
        if(oldVal!=null) {
            this.sourceVal = oldVal.toString();
        }
        if(newVal!=null) {
            this.nowVal = newVal.toString();
        }
        this.changeDate=new Date();
        this.isNew="1";
        this.isUpdate="1";
        this.isShow="0";
        this.text=text;
        this.source=platform;
        this.markerRegionId=markerRegionId;
    }

    public static Map<String,String> keyMap=new HashMap<>();
    public String getText(String key){
        if(keyMap.size()==0){
            keyMap.put("activityName","活动名称");
            keyMap.put("activityType","活动类型");
            keyMap.put("address","活动场地名称");
            keyMap.put("actAddr","举办城市");
            keyMap.put("addressType","场地类型");
            keyMap.put("number","活动期间单日最大参加人数");
            keyMap.put("activityDate","活动时间");
            keyMap.put("sponsor","单位名称");
        }
        return keyMap.containsKey(key) ? keyMap.get(key) : key;
    }


}
