package com.bcxin.risk.expert.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 存储专家待审核资料，审核通过后会copy到专家用户表中
 * 完善专家信息会存放
 * 修改专家信息会存放
 * @author hzp
 */
@Entity
@Table(name = "risk_expertcheckinfo")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicUpdate(true)
@DynamicInsert(true)
public class ExpertCheckInfo extends BaseBean {
    /**
     * 专家用户id
     */
    private Long userId;
    /**
     * 所属机构
     */
    private Long orgId;
    /**
     * 真实名称
     */
    private String realName;
    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机
     */
    private String phone;

    /**
     * 电子签名
     */
    private String signature;
    /**
     * 电子签名
     */
    private String cardNo;
    /**
     * 性别
     */
    private String sex;
    /**
     * 出生年月
     */
    private String birthday;
    /**
     * 政治面貌
     */
    private String political;
    /**
     * 民族
     */
    private String nation;
    /**
     * 婚姻状况
     */
    private String marital;
    /**
     * 最高学历
     */
    private String education;
    /**
     * 学历证号
     */
    private String educationNo;
    /**
     * 籍贯code
     */
    private String nativeInfoCode;
    /**
     * 籍贯
     */
    private String nativeInfo;
    /**
     * 任职公司部门
     */
    private String companyOrDept;
    /**
     * 职务
     */
    private String position;
    /**
     * 职称
     */
    private String workTitle;
    /**
     * 资质证书
     */
    private String aptitude_cert;
    /**
     * 工作居住地code
     */
    private String jobLiveAddrCode;
    /**
     * 工作居住地
     */
    private String jobLiveAddr;
    /**
     * 所属行业
     */
    private String industryCategory;
    /**
     * 擅长专业
     */
    private String professional;
    /**
     * 教育经历
     */
    private String educationExperience;
    /**
     * 工作经历
     */
    private String workExperience;
    /**
     * 学术团体任职经历
     */
    private String learningExperience;
    /**
     * 曾主持/参加的课题、项目经历
     */
    private String projectExperience;
    /**
     * 曾发表的学术文章
     */
    private String learningPaper;
    /**
     * 曾获得的成功
     */
    private String successExperience;
    /**
     * 个人业绩实例
     */
    private String personAchievement;
    /**
     * 备注
     */
    private String remarks;
    /**
     * 审核状态，待审核 1，通过 2、不通过3
     */
    private String checkStatus;
    /**
     * 审核意见
     */
    private String checkOpinion;
    /**
     * 等级（1：初级，2：中级，3：高级）
     */
    private String level;

    /**
     * 专家来源
     */
    private String expertSource;

    /**
     * 任务报价
     */
    private String taskQuote;
}
