package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.draft.ComposeFile;
import com.bcxin.risk.compose.draft.ComposeTask;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author hzp
 * 撰写动态看板数据结构
 * 数据结构属性与对应的模板key相对应
 */
@Data
public class DynamicZhuanXiePanel implements Serializable {

    /**
     * 操作人
     */
    private String operateName;
    private String userName;
    /**
     * 报告操作人
     */
    private String reportOperateName;
    private String operateId;

    private String activityId;

    private String activityName;

    private String orgId;

    /**
     * 风评机构
     */
    private String orgName;

    /**
     * 撰写相关人员
     */
    private String zxUserList;

    private String reportId;

    /**
     * 报告url
     */
    private String reportUrl;


    public DynamicZhuanXiePanel(User operateUser, Report report, ComposeFile composeFile, Org org, List<ComposeTask> composeTaskList){
        Activity activity=report.getActivity();
        this.activityId=safeTransfer(activity.getOid());
        this.activityName=safeTransfer(activity.getName());

        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }

        if(org!=null){
            this.orgId=safeTransfer(org.getOid());
            this.orgName=safeTransfer(org.getName());
        }

        this.reportId=report.getOid().toString();
        if(composeFile !=null){
            this.reportUrl=composeFile.getFileUrl();
        }

        // 报告编写人名称
        if(report.getUser()!=null){
            this.reportOperateName=report.getUser().getRealName();
        }

        this.zxUserList=getZxUser(composeTaskList);
    }

    /**
     * 获取撰写相关用户
     * @param composeTaskList
     * @return
     */
    private static String getZxUser(List<ComposeTask> composeTaskList){
        String userNameList="";
        if(composeTaskList!=null && composeTaskList.size()>0){
            for(ComposeTask composeTask : composeTaskList){
                if(composeTask.getAssgin()!=null){
                    if(StringUtil.isNotEmpty(composeTask.getAssgin().getRealName())){
                        userNameList+=composeTask.getAssgin().getRealName()+"、";
                    }else{
                        userNameList+=composeTask.getAssgin().getUserName()+"、";
                    }
                }
            }
            if(StringUtil.isNotEmpty(userNameList)){
                userNameList=userNameList.substring(0,userNameList.length()-1);
            }
        }
        return userNameList;
    }

    private static String safeTransfer(Object obj){
        if(obj!=null){
            return obj.toString();
        }
        return "";
    }
}
