package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 场地fieldset
 * @author 070
 */
@Entity
@Table(name = "venue_fieldset")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class VenueFieldset extends BaseBean {

    /** 场馆名称 */
    private String name;

    /** 所属省代码 */
    private String type;

    /** fieldset */
    private String fieldset;

}