package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 专业规范信息库
 */
@Entity
@Table(name = "RISK_ComposeStandard")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeStandard extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 规范类型
     */
    private String type;

    /**
     * 网址链接
     */
    private String link;

    /**
     * 规范名称
     */
    private String name;

    /**
     * 规范文件
     */
    private String fileUrl;

}
