package com.bcxin.risk.common.vo;

/**
 * @author hzp
 * 发送消息类型
 */
public enum MessageTypeEnum {

    ALL("ALL","所有类型"),
    SYS("SYS","站内信"),
    SMS("SMS","短信"),
    EMAIL("EMAIL","邮件");

    private String key;
    private String alias;

    MessageTypeEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(MessageTypeEnum e : MessageTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
