package com.bcxin.risk.common.dto.data;


import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

/**
 * 订单信息dto
 */
@Data
public class MessageDataDto {

    private Object oid; //  消息编号

    private String readStatus; // 阅读状态（字典）

    private String title;  // 标题

    private String content; // 内容

    private String keyword;

    private String readTime; // 阅读时间

    private String createOn; // 阅读时间

    private String url; // 消息对应url

    private String checkFun; // 校验方法

    private Page page;

    public MessageDataDto(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.readStatus = safeTransfor(map.get("readStatus"));
        this.title = safeTransfor(map.get("title"));
        this.content = safeTransfor(map.get("content"));
        this.keyword = safeTransfor(map.get("keyword"));
        this.readTime = safeTransfor(map.get("readTime"));
        this.url = safeTransfor(map.get("url"));
        this.checkFun = safeTransfor(map.get("checkFun"));
        this.createOn = safeTransfor(map.get("createOn"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author llc
     * @date 2017年5月6日
     * @注意事项 </b>
     * <b>
     */
    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}

