/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.draft.ComposeFile;
import com.bcxin.risk.compose.draft.ComposeTask;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;

public class DynamicZhuanXiePanel
implements Serializable {
    private String operateName;
    private String userName;
    private String reportOperateName;
    private String operateId;
    private String activityId;
    private String activityName;
    private String orgId;
    private String orgName;
    private String zxUserList;
    private String reportId;
    private String reportUrl;

    public DynamicZhuanXiePanel(User operateUser, Report report, ComposeFile composeFile, Org org, List<ComposeTask> composeTaskList) {
        Activity activity = report.getActivity();
        this.activityId = DynamicZhuanXiePanel.safeTransfer(activity.getOid());
        this.activityName = DynamicZhuanXiePanel.safeTransfer(activity.getName());
        if (operateUser != null) {
            this.operateId = DynamicZhuanXiePanel.safeTransfer(operateUser.getOid());
            this.userName = operateUser.getUserName();
            if (StringUtil.isEmpty(this.operateName)) {
                this.operateName = DynamicZhuanXiePanel.safeTransfer(operateUser.getUserName());
            }
        }
        if (org != null) {
            this.orgId = DynamicZhuanXiePanel.safeTransfer(org.getOid());
            this.orgName = DynamicZhuanXiePanel.safeTransfer(org.getName());
        }
        this.reportId = report.getOid().toString();
        if (composeFile != null) {
            this.reportUrl = composeFile.getFileUrl();
        }
        if (report.getUser() != null) {
            this.reportOperateName = report.getUser().getRealName();
        }
        this.zxUserList = DynamicZhuanXiePanel.getZxUser(composeTaskList);
    }

    private static String getZxUser(List<ComposeTask> composeTaskList) {
        String userNameList = "";
        if (composeTaskList != null && composeTaskList.size() > 0) {
            for (ComposeTask composeTask : composeTaskList) {
                if (composeTask.getAssgin() == null) continue;
                if (StringUtil.isNotEmpty(composeTask.getAssgin().getRealName())) {
                    userNameList = userNameList + composeTask.getAssgin().getRealName() + "\u3001";
                    continue;
                }
                userNameList = userNameList + composeTask.getAssgin().getUserName() + "\u3001";
            }
            if (StringUtil.isNotEmpty(userNameList)) {
                userNameList = userNameList.substring(0, userNameList.length() - 1);
            }
        }
        return userNameList;
    }

    private static String safeTransfer(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    @Generated
    public String getOperateName() {
        return this.operateName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getReportOperateName() {
        return this.reportOperateName;
    }

    @Generated
    public String getOperateId() {
        return this.operateId;
    }

    @Generated
    public String getActivityId() {
        return this.activityId;
    }

    @Generated
    public String getActivityName() {
        return this.activityName;
    }

    @Generated
    public String getOrgId() {
        return this.orgId;
    }

    @Generated
    public String getOrgName() {
        return this.orgName;
    }

    @Generated
    public String getZxUserList() {
        return this.zxUserList;
    }

    @Generated
    public String getReportId() {
        return this.reportId;
    }

    @Generated
    public String getReportUrl() {
        return this.reportUrl;
    }

    @Generated
    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setReportOperateName(String reportOperateName) {
        this.reportOperateName = reportOperateName;
    }

    @Generated
    public void setOperateId(String operateId) {
        this.operateId = operateId;
    }

    @Generated
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Generated
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @Generated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Generated
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Generated
    public void setZxUserList(String zxUserList) {
        this.zxUserList = zxUserList;
    }

    @Generated
    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    @Generated
    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicZhuanXiePanel)) {
            return false;
        }
        DynamicZhuanXiePanel other = (DynamicZhuanXiePanel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$operateName = this.getOperateName();
        String other$operateName = other.getOperateName();
        if (this$operateName == null ? other$operateName != null : !this$operateName.equals(other$operateName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$reportOperateName = this.getReportOperateName();
        String other$reportOperateName = other.getReportOperateName();
        if (this$reportOperateName == null ? other$reportOperateName != null : !this$reportOperateName.equals(other$reportOperateName)) {
            return false;
        }
        String this$operateId = this.getOperateId();
        String other$operateId = other.getOperateId();
        if (this$operateId == null ? other$operateId != null : !this$operateId.equals(other$operateId)) {
            return false;
        }
        String this$activityId = this.getActivityId();
        String other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !this$activityId.equals(other$activityId)) {
            return false;
        }
        String this$activityName = this.getActivityName();
        String other$activityName = other.getActivityName();
        if (this$activityName == null ? other$activityName != null : !this$activityName.equals(other$activityName)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$zxUserList = this.getZxUserList();
        String other$zxUserList = other.getZxUserList();
        if (this$zxUserList == null ? other$zxUserList != null : !this$zxUserList.equals(other$zxUserList)) {
            return false;
        }
        String this$reportId = this.getReportId();
        String other$reportId = other.getReportId();
        if (this$reportId == null ? other$reportId != null : !this$reportId.equals(other$reportId)) {
            return false;
        }
        String this$reportUrl = this.getReportUrl();
        String other$reportUrl = other.getReportUrl();
        return !(this$reportUrl == null ? other$reportUrl != null : !this$reportUrl.equals(other$reportUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamicZhuanXiePanel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $operateName = this.getOperateName();
        result = result * 59 + ($operateName == null ? 43 : $operateName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $reportOperateName = this.getReportOperateName();
        result = result * 59 + ($reportOperateName == null ? 43 : $reportOperateName.hashCode());
        String $operateId = this.getOperateId();
        result = result * 59 + ($operateId == null ? 43 : $operateId.hashCode());
        String $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : $activityId.hashCode());
        String $activityName = this.getActivityName();
        result = result * 59 + ($activityName == null ? 43 : $activityName.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $zxUserList = this.getZxUserList();
        result = result * 59 + ($zxUserList == null ? 43 : $zxUserList.hashCode());
        String $reportId = this.getReportId();
        result = result * 59 + ($reportId == null ? 43 : $reportId.hashCode());
        String $reportUrl = this.getReportUrl();
        result = result * 59 + ($reportUrl == null ? 43 : $reportUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamicZhuanXiePanel(operateName=" + this.getOperateName() + ", userName=" + this.getUserName() + ", reportOperateName=" + this.getReportOperateName() + ", operateId=" + this.getOperateId() + ", activityId=" + this.getActivityId() + ", activityName=" + this.getActivityName() + ", orgId=" + this.getOrgId() + ", orgName=" + this.getOrgName() + ", zxUserList=" + this.getZxUserList() + ", reportId=" + this.getReportId() + ", reportUrl=" + this.getReportUrl() + ")";
    }
}

