/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.Transaction;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class DynamicOrderPanel
implements Serializable {
    private String orderId;
    private String orderNo;
    private String activityId;
    private String activityName;
    private String paymentMethod;
    private String paymentType;
    private String paymentAmount;
    private String sourceAmount;
    private String updateAfterAmount;
    private String operateId;
    private String operateName;
    private String userName;
    private String contractId;
    private String contractName;
    private String reportUrgentName;
    private String transactionAmount;
    private String orgNameList;

    public DynamicOrderPanel(User operateUser, OrderForm orderForm, Transaction transaction, Report report, List<ActivityCooperDTO> orgList) {
        Activity activity = orderForm.getActivity();
        this.activityId = DynamicOrderPanel.safeTransfer(activity.getOid());
        this.activityName = DynamicOrderPanel.safeTransfer(activity.getName());
        this.contractId = DynamicOrderPanel.safeTransfer(activity.getOrg().getOid());
        this.contractName = DynamicOrderPanel.safeTransfer(activity.getOrg().getName());
        this.orderId = DynamicOrderPanel.safeTransfer(orderForm.getOid());
        this.orderNo = DynamicOrderPanel.safeTransfer(orderForm.getOrderNo());
        this.paymentAmount = DynamicOrderPanel.safeTransfer(orderForm.getAmount());
        this.sourceAmount = DynamicOrderPanel.safeTransfer(orderForm.getSourceAmount());
        this.updateAfterAmount = DynamicOrderPanel.safeTransfer(orderForm.getAmount());
        if (transaction != null) {
            this.paymentMethod = DynamicOrderPanel.safeTransfer(transaction.getPaymentMode());
            this.paymentType = DynamicOrderPanel.safeTransfer(transaction.getPaymentType());
            if (Objects.equals("1", this.paymentMethod)) {
                this.paymentMethod = "\u7ebf\u4e0a\u652f\u4ed8";
            } else if (Objects.equals("2", this.paymentMethod)) {
                this.paymentMethod = "\u7ebf\u4e0b\u652f\u4ed8";
            }
            this.transactionAmount = DynamicOrderPanel.safeTransfer(transaction.getAmount());
        }
        if (report != null) {
            String reportUrgent = DynamicOrderPanel.safeTransfer(report.getReportUrgent());
            if (Objects.equals("0", reportUrgent)) {
                this.reportUrgentName = "\u4e0d\u9700\u8981\u52a0\u6025";
            } else if (Objects.equals("3", reportUrgent)) {
                this.reportUrgentName = "\u9700\u8981\u52a0\u6025";
            }
        }
        if (operateUser != null) {
            this.operateId = DynamicOrderPanel.safeTransfer(operateUser.getOid());
            this.userName = operateUser.getUserName();
            if (StringUtil.isEmpty(this.operateName)) {
                this.operateName = DynamicOrderPanel.safeTransfer(operateUser.getUserName());
            }
        }
        this.orgNameList = DynamicOrderPanel.getOrgNameList(orgList);
    }

    private static String getOrgNameList(List<ActivityCooperDTO> orgList) {
        if (orgList == null || orgList.size() == 0) {
            return "";
        }
        String orgNameList = "";
        for (ActivityCooperDTO dto : orgList) {
            orgNameList = orgNameList + dto.getName() + "\u3001";
        }
        if (StringUtil.isNotEmpty(orgNameList)) {
            orgNameList = orgNameList.substring(0, orgNameList.length() - 1);
        }
        return orgNameList;
    }

    private static String safeTransfer(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    @Generated
    public String getOrderId() {
        return this.orderId;
    }

    @Generated
    public String getOrderNo() {
        return this.orderNo;
    }

    @Generated
    public String getActivityId() {
        return this.activityId;
    }

    @Generated
    public String getActivityName() {
        return this.activityName;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public String getPaymentType() {
        return this.paymentType;
    }

    @Generated
    public String getPaymentAmount() {
        return this.paymentAmount;
    }

    @Generated
    public String getSourceAmount() {
        return this.sourceAmount;
    }

    @Generated
    public String getUpdateAfterAmount() {
        return this.updateAfterAmount;
    }

    @Generated
    public String getOperateId() {
        return this.operateId;
    }

    @Generated
    public String getOperateName() {
        return this.operateName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getContractId() {
        return this.contractId;
    }

    @Generated
    public String getContractName() {
        return this.contractName;
    }

    @Generated
    public String getReportUrgentName() {
        return this.reportUrgentName;
    }

    @Generated
    public String getTransactionAmount() {
        return this.transactionAmount;
    }

    @Generated
    public String getOrgNameList() {
        return this.orgNameList;
    }

    @Generated
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Generated
    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @Generated
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Generated
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Generated
    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    @Generated
    public void setPaymentAmount(String paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    @Generated
    public void setSourceAmount(String sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    @Generated
    public void setUpdateAfterAmount(String updateAfterAmount) {
        this.updateAfterAmount = updateAfterAmount;
    }

    @Generated
    public void setOperateId(String operateId) {
        this.operateId = operateId;
    }

    @Generated
    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    @Generated
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @Generated
    public void setReportUrgentName(String reportUrgentName) {
        this.reportUrgentName = reportUrgentName;
    }

    @Generated
    public void setTransactionAmount(String transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    @Generated
    public void setOrgNameList(String orgNameList) {
        this.orgNameList = orgNameList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicOrderPanel)) {
            return false;
        }
        DynamicOrderPanel other = (DynamicOrderPanel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        String this$activityId = this.getActivityId();
        String other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !this$activityId.equals(other$activityId)) {
            return false;
        }
        String this$activityName = this.getActivityName();
        String other$activityName = other.getActivityName();
        if (this$activityName == null ? other$activityName != null : !this$activityName.equals(other$activityName)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        String this$paymentType = this.getPaymentType();
        String other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$paymentAmount = this.getPaymentAmount();
        String other$paymentAmount = other.getPaymentAmount();
        if (this$paymentAmount == null ? other$paymentAmount != null : !this$paymentAmount.equals(other$paymentAmount)) {
            return false;
        }
        String this$sourceAmount = this.getSourceAmount();
        String other$sourceAmount = other.getSourceAmount();
        if (this$sourceAmount == null ? other$sourceAmount != null : !this$sourceAmount.equals(other$sourceAmount)) {
            return false;
        }
        String this$updateAfterAmount = this.getUpdateAfterAmount();
        String other$updateAfterAmount = other.getUpdateAfterAmount();
        if (this$updateAfterAmount == null ? other$updateAfterAmount != null : !this$updateAfterAmount.equals(other$updateAfterAmount)) {
            return false;
        }
        String this$operateId = this.getOperateId();
        String other$operateId = other.getOperateId();
        if (this$operateId == null ? other$operateId != null : !this$operateId.equals(other$operateId)) {
            return false;
        }
        String this$operateName = this.getOperateName();
        String other$operateName = other.getOperateName();
        if (this$operateName == null ? other$operateName != null : !this$operateName.equals(other$operateName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$contractId = this.getContractId();
        String other$contractId = other.getContractId();
        if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
            return false;
        }
        String this$contractName = this.getContractName();
        String other$contractName = other.getContractName();
        if (this$contractName == null ? other$contractName != null : !this$contractName.equals(other$contractName)) {
            return false;
        }
        String this$reportUrgentName = this.getReportUrgentName();
        String other$reportUrgentName = other.getReportUrgentName();
        if (this$reportUrgentName == null ? other$reportUrgentName != null : !this$reportUrgentName.equals(other$reportUrgentName)) {
            return false;
        }
        String this$transactionAmount = this.getTransactionAmount();
        String other$transactionAmount = other.getTransactionAmount();
        if (this$transactionAmount == null ? other$transactionAmount != null : !this$transactionAmount.equals(other$transactionAmount)) {
            return false;
        }
        String this$orgNameList = this.getOrgNameList();
        String other$orgNameList = other.getOrgNameList();
        return !(this$orgNameList == null ? other$orgNameList != null : !this$orgNameList.equals(other$orgNameList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamicOrderPanel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        String $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : $activityId.hashCode());
        String $activityName = this.getActivityName();
        result = result * 59 + ($activityName == null ? 43 : $activityName.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        String $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $paymentAmount = this.getPaymentAmount();
        result = result * 59 + ($paymentAmount == null ? 43 : $paymentAmount.hashCode());
        String $sourceAmount = this.getSourceAmount();
        result = result * 59 + ($sourceAmount == null ? 43 : $sourceAmount.hashCode());
        String $updateAfterAmount = this.getUpdateAfterAmount();
        result = result * 59 + ($updateAfterAmount == null ? 43 : $updateAfterAmount.hashCode());
        String $operateId = this.getOperateId();
        result = result * 59 + ($operateId == null ? 43 : $operateId.hashCode());
        String $operateName = this.getOperateName();
        result = result * 59 + ($operateName == null ? 43 : $operateName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
        String $contractName = this.getContractName();
        result = result * 59 + ($contractName == null ? 43 : $contractName.hashCode());
        String $reportUrgentName = this.getReportUrgentName();
        result = result * 59 + ($reportUrgentName == null ? 43 : $reportUrgentName.hashCode());
        String $transactionAmount = this.getTransactionAmount();
        result = result * 59 + ($transactionAmount == null ? 43 : $transactionAmount.hashCode());
        String $orgNameList = this.getOrgNameList();
        result = result * 59 + ($orgNameList == null ? 43 : $orgNameList.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamicOrderPanel(orderId=" + this.getOrderId() + ", orderNo=" + this.getOrderNo() + ", activityId=" + this.getActivityId() + ", activityName=" + this.getActivityName() + ", paymentMethod=" + this.getPaymentMethod() + ", paymentType=" + this.getPaymentType() + ", paymentAmount=" + this.getPaymentAmount() + ", sourceAmount=" + this.getSourceAmount() + ", updateAfterAmount=" + this.getUpdateAfterAmount() + ", operateId=" + this.getOperateId() + ", operateName=" + this.getOperateName() + ", userName=" + this.getUserName() + ", contractId=" + this.getContractId() + ", contractName=" + this.getContractName() + ", reportUrgentName=" + this.getReportUrgentName() + ", transactionAmount=" + this.getTransactionAmount() + ", orgNameList=" + this.getOrgNameList() + ")";
    }
}

