/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class DynamicFengPingPanel
implements Serializable {
    private String reportId;
    private String reportUrl;
    private String reportVersion;
    private String operateName;
    private String operateId;
    private String userName;
    private String activityId;
    private String activityName;
    private String contractId;
    private String contractName;
    private String orgId;
    private String orgName;
    private String reportVer;
    private String reSubmit;

    public DynamicFengPingPanel() {
    }

    public DynamicFengPingPanel(User operateUser, Org org, Activity activity, String reportUrl) {
        this.activityId = DynamicFengPingPanel.safeTransfer(activity.getOid());
        this.activityName = DynamicFengPingPanel.safeTransfer(activity.getName());
        if (operateUser != null) {
            this.operateId = DynamicFengPingPanel.safeTransfer(operateUser.getOid());
            this.userName = operateUser.getUserName();
            if (StringUtil.isEmpty(this.operateName)) {
                this.operateName = DynamicFengPingPanel.safeTransfer(operateUser.getUserName());
            }
        }
        if (org != null) {
            this.orgId = org.getOid().toString();
            this.orgName = org.getName();
        }
        this.reportUrl = reportUrl;
    }

    public DynamicFengPingPanel(User operateUser, Org org, Activity activity, String reportUrl, String reportType) {
        this.activityId = DynamicFengPingPanel.safeTransfer(activity.getOid());
        this.activityName = DynamicFengPingPanel.safeTransfer(activity.getName());
        if (operateUser != null) {
            this.operateId = DynamicFengPingPanel.safeTransfer(operateUser.getOid());
            this.userName = operateUser.getUserName();
            if (StringUtil.isEmpty(this.operateName)) {
                this.operateName = DynamicFengPingPanel.safeTransfer(operateUser.getUserName());
            }
        }
        if (org != null) {
            this.orgId = org.getOid().toString();
            this.orgName = org.getName();
        }
        this.reportUrl = reportUrl;
        this.reportVer = Objects.equals(reportType, "1") ? "\u7f16\u5199\u4eba\u5458" : (Objects.equals(reportType, "2") ? "\u5ba1\u6838\u4eba\u5458" : (Objects.equals(reportType, "3") ? "\u8bc4\u4f30\u4e13\u5bb6-\u62a5\u544a\u64b0\u5199\u4e13\u5bb6" : (Objects.equals(reportType, "4") ? "\u7ec8\u7a3f" : "\u672c\u5730\u4e0a\u4f20")));
    }

    public DynamicFengPingPanel(User operateUser, OrderForm orderForm, Report report, Org org) {
        Activity activity = orderForm.getActivity();
        this.activityId = DynamicFengPingPanel.safeTransfer(activity.getOid());
        this.activityName = DynamicFengPingPanel.safeTransfer(activity.getName());
        this.contractId = DynamicFengPingPanel.safeTransfer(activity.getOrg().getOid());
        this.contractName = DynamicFengPingPanel.safeTransfer(activity.getOrg().getName());
        if (operateUser != null) {
            this.operateId = DynamicFengPingPanel.safeTransfer(operateUser.getOid());
            this.userName = operateUser.getUserName();
            if (StringUtil.isEmpty(this.operateName)) {
                this.operateName = DynamicFengPingPanel.safeTransfer(operateUser.getUserName());
            }
        }
        if (report != null) {
            this.reportId = DynamicFengPingPanel.safeTransfer(report.getOid());
            this.reportUrl = "";
            this.reportVersion = "";
        }
        if (org != null) {
            this.orgId = DynamicFengPingPanel.safeTransfer(org.getOid());
            this.orgName = DynamicFengPingPanel.safeTransfer(org.getName());
        }
    }

    public Org getPingGuOrg(List<ActivityCooperDTO> orgList) {
        Org org = new Org();
        if (orgList != null) {
            for (ActivityCooperDTO dto : orgList) {
                if (!Objects.equals(dto.getServiceOrgType(), "1")) continue;
                org.setOid(Long.parseLong(dto.getOid()));
                org.setName(dto.getName());
                return org;
            }
        }
        return null;
    }

    private static String safeTransfer(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    @Generated
    public String getReportId() {
        return this.reportId;
    }

    @Generated
    public String getReportUrl() {
        return this.reportUrl;
    }

    @Generated
    public String getReportVersion() {
        return this.reportVersion;
    }

    @Generated
    public String getOperateName() {
        return this.operateName;
    }

    @Generated
    public String getOperateId() {
        return this.operateId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getActivityId() {
        return this.activityId;
    }

    @Generated
    public String getActivityName() {
        return this.activityName;
    }

    @Generated
    public String getContractId() {
        return this.contractId;
    }

    @Generated
    public String getContractName() {
        return this.contractName;
    }

    @Generated
    public String getOrgId() {
        return this.orgId;
    }

    @Generated
    public String getOrgName() {
        return this.orgName;
    }

    @Generated
    public String getReportVer() {
        return this.reportVer;
    }

    @Generated
    public String getReSubmit() {
        return this.reSubmit;
    }

    @Generated
    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    @Generated
    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    @Generated
    public void setReportVersion(String reportVersion) {
        this.reportVersion = reportVersion;
    }

    @Generated
    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    @Generated
    public void setOperateId(String operateId) {
        this.operateId = operateId;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Generated
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @Generated
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    @Generated
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @Generated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Generated
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Generated
    public void setReportVer(String reportVer) {
        this.reportVer = reportVer;
    }

    @Generated
    public void setReSubmit(String reSubmit) {
        this.reSubmit = reSubmit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicFengPingPanel)) {
            return false;
        }
        DynamicFengPingPanel other = (DynamicFengPingPanel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reportId = this.getReportId();
        String other$reportId = other.getReportId();
        if (this$reportId == null ? other$reportId != null : !this$reportId.equals(other$reportId)) {
            return false;
        }
        String this$reportUrl = this.getReportUrl();
        String other$reportUrl = other.getReportUrl();
        if (this$reportUrl == null ? other$reportUrl != null : !this$reportUrl.equals(other$reportUrl)) {
            return false;
        }
        String this$reportVersion = this.getReportVersion();
        String other$reportVersion = other.getReportVersion();
        if (this$reportVersion == null ? other$reportVersion != null : !this$reportVersion.equals(other$reportVersion)) {
            return false;
        }
        String this$operateName = this.getOperateName();
        String other$operateName = other.getOperateName();
        if (this$operateName == null ? other$operateName != null : !this$operateName.equals(other$operateName)) {
            return false;
        }
        String this$operateId = this.getOperateId();
        String other$operateId = other.getOperateId();
        if (this$operateId == null ? other$operateId != null : !this$operateId.equals(other$operateId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$activityId = this.getActivityId();
        String other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !this$activityId.equals(other$activityId)) {
            return false;
        }
        String this$activityName = this.getActivityName();
        String other$activityName = other.getActivityName();
        if (this$activityName == null ? other$activityName != null : !this$activityName.equals(other$activityName)) {
            return false;
        }
        String this$contractId = this.getContractId();
        String other$contractId = other.getContractId();
        if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
            return false;
        }
        String this$contractName = this.getContractName();
        String other$contractName = other.getContractName();
        if (this$contractName == null ? other$contractName != null : !this$contractName.equals(other$contractName)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$reportVer = this.getReportVer();
        String other$reportVer = other.getReportVer();
        if (this$reportVer == null ? other$reportVer != null : !this$reportVer.equals(other$reportVer)) {
            return false;
        }
        String this$reSubmit = this.getReSubmit();
        String other$reSubmit = other.getReSubmit();
        return !(this$reSubmit == null ? other$reSubmit != null : !this$reSubmit.equals(other$reSubmit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamicFengPingPanel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reportId = this.getReportId();
        result = result * 59 + ($reportId == null ? 43 : $reportId.hashCode());
        String $reportUrl = this.getReportUrl();
        result = result * 59 + ($reportUrl == null ? 43 : $reportUrl.hashCode());
        String $reportVersion = this.getReportVersion();
        result = result * 59 + ($reportVersion == null ? 43 : $reportVersion.hashCode());
        String $operateName = this.getOperateName();
        result = result * 59 + ($operateName == null ? 43 : $operateName.hashCode());
        String $operateId = this.getOperateId();
        result = result * 59 + ($operateId == null ? 43 : $operateId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : $activityId.hashCode());
        String $activityName = this.getActivityName();
        result = result * 59 + ($activityName == null ? 43 : $activityName.hashCode());
        String $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
        String $contractName = this.getContractName();
        result = result * 59 + ($contractName == null ? 43 : $contractName.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $reportVer = this.getReportVer();
        result = result * 59 + ($reportVer == null ? 43 : $reportVer.hashCode());
        String $reSubmit = this.getReSubmit();
        result = result * 59 + ($reSubmit == null ? 43 : $reSubmit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamicFengPingPanel(reportId=" + this.getReportId() + ", reportUrl=" + this.getReportUrl() + ", reportVersion=" + this.getReportVersion() + ", operateName=" + this.getOperateName() + ", operateId=" + this.getOperateId() + ", userName=" + this.getUserName() + ", activityId=" + this.getActivityId() + ", activityName=" + this.getActivityName() + ", contractId=" + this.getContractId() + ", contractName=" + this.getContractName() + ", orgId=" + this.getOrgId() + ", orgName=" + this.getOrgName() + ", reportVer=" + this.getReportVer() + ", reSubmit=" + this.getReSubmit() + ")";
    }
}

